/**
 * 
 */
package org.gcube.informationsystem.model.reference.properties;

import java.util.Date;
import java.util.UUID;

import org.gcube.com.fasterxml.jackson.annotation.JsonFormat;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Header
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=HeaderImpl.class)
@TypeMetadata(name = Header.NAME, description = "This class provides metadata per every IdentifiableElement", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface Header extends Property {

	public static final String NAME = "Header"; // Header.class.getSimpleName();

	/**
	 * Used to set Creator when the user is not known
	 */
	public static final String UNKNOWN_USER = "UNKNOWN_USER";

	public static final String UUID_PROPERTY = "uuid";
	public static final String CREATED_BY_PROPERTY = "createdBy";
	public static final String CREATION_TIME_PROPERTY = "creationTime";
	public static final String LAST_UPDATE_BY_PROPERTY = "lastUpdateBy";
	public static final String LAST_UPDATE_TIME_PROPERTY = "lastUpdateTime";

	/**
	 * Used when requested to include contexts in header.
	 * This is not a native property (it is just generated by server for administration clients convenience)
	 */
	public static final String __CONTEXTS = "contexts";
	
	
	@ISProperty(name = UUID_PROPERTY, description = "This UUID is be used to identify the Entity or the Relation univocally.", readonly = true, mandatory = true, nullable = false)
	public UUID getUUID();

	public void setUUID(UUID uuid);

	@ISProperty(name = CREATED_BY_PROPERTY, description = "The user that created the Entity or the Relation. It is initialized at creation time. ", readonly = true, mandatory = true, nullable = false)
	public String getCreatedBy();

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Element.DATETIME_PATTERN)
	@ISProperty(name = CREATION_TIME_PROPERTY, description = "Creation time. It represents the difference, measured in milliseconds, between the creation time and midnight, January 1, 1970, UTC.", readonly = true, mandatory = true, nullable = false)
	public Date getCreationTime();

	@ISProperty(name = LAST_UPDATE_BY_PROPERTY, description = "The user that made the last update to the Entity or the Relation. At creation time, it assumes the same value of creator.", mandatory = true, nullable = false)
	public String getLastUpdateBy();

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Element.DATETIME_PATTERN)
	@ISProperty(name = LAST_UPDATE_TIME_PROPERTY, description = "Last Update time. At creation time it assumes the same value of creationTime. It represents the difference, measured in milliseconds, between the creation time and midnight, January 1, 1970, UTC.", mandatory = true, nullable = false)
	public Date getLastUpdateTime();

}