package org.gcube.informationsystem.types;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.com.fasterxml.jackson.databind.DeserializationFeature;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.types.impl.TypeImpl;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.entities.FacetType;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.types.reference.properties.PropertyType;
import org.gcube.informationsystem.types.reference.relations.ConsistsOfType;
import org.gcube.informationsystem.types.reference.relations.IsRelatedToType;
import org.gcube.informationsystem.types.reference.relations.RelationType;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class TypeMapper {

	private final static String NAME = "NAME";
	
	
	protected static final ObjectMapper mapper;
	
	static {
		mapper = new ObjectMapper();
		mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		
		mapper.registerSubtypes(Type.class);
		
		mapper.registerSubtypes(EntityType.class);
		mapper.registerSubtypes(ResourceType.class);
		mapper.registerSubtypes(FacetType.class);
		
		mapper.registerSubtypes(RelationType.class);
		mapper.registerSubtypes(IsRelatedToType.class);
		mapper.registerSubtypes(ConsistsOfType.class);
		
		mapper.registerSubtypes(PropertyType.class);
		mapper.registerSubtypes(PropertyDefinition.class);
		mapper.registerSubtypes(LinkedEntity.class);
		
		// TODO
		// mapper.registerSubtypes(LinkedResource.class);
		// mapper.registerSubtypes(LinkedFacet.class);
	}
	
	public static String serializeTypeDefinition(Type type) throws Exception{
		String json = mapper.writeValueAsString(type);
		return json;
	}

	public static Type deserializeTypeDefinition(String json) throws Exception{
		Type type = mapper.readValue(json, Type.class);
		return type;
	}
	
	public static String serializeTypeDefinitions(List<Type> typeDefinitions) throws Exception{
		JavaType javaType = mapper.getTypeFactory().constructCollectionType(List.class, Type.class);
		return mapper.writerFor(javaType).writeValueAsString(typeDefinitions);
	}
	
	public static List<Type> deserializeTypeDefinitions(String json) throws Exception{
		JavaType javaType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, Type.class);
		return mapper.readValue(json, javaType);
	}
	
	
	
	// TODO move somewhere else, probably in Element
	
	public static <E extends Element> Type createTypeDefinition(Class<E> clz) {
		Type type = TypeImpl.getInstance(clz);
		return type;
	}
	
	public static <E extends Element> String serializeType(Class<E> clz) throws Exception{
		Type type = createTypeDefinition(clz);
		return serializeTypeDefinition(type);
	}
	
	public static String getType(Class<? extends Element> clz){
		if(clz.isAnnotationPresent(JsonTypeName.class)) {
			JsonTypeName jsonTypeName = clz.getAnnotation(JsonTypeName.class);
			return jsonTypeName.value();
		}
		return getStaticStringFieldByName(clz, NAME, clz.getSimpleName());
	}
	
	public static String getStaticStringFieldByName(Class<? extends Element> clz, String fieldName, String defaultValue){
		Field field;
		try {
			field = clz.getDeclaredField(fieldName);
			field.setAccessible(true);
			return (String) field.get(null);
		} catch (NoSuchFieldException | SecurityException | IllegalArgumentException | IllegalAccessException e) {
			return defaultValue;
		}
	}
}
