/**
 * 
 */
package org.gcube.informationsystem.model.impl.properties;

import java.security.Key;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.informationsystem.model.reference.properties.Encrypted;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = Encrypted.NAME)
public class EncryptedImpl extends PropertyImpl implements Encrypted {
	
	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 7823031209294161865L;
	
	@JsonIgnore
	protected String encryptedValue;
	
	public EncryptedImpl() {
		super();
	}
	
	@Override
	public String getEncryptedValue() {
		return encryptedValue;
	}
	
	@Override
	public void setEncryptedValue(String encryptedValue) {
		this.encryptedValue = encryptedValue;
	}
	
	public static String encrypt(String value) throws Exception {
		return StringEncrypter.getEncrypter().encrypt(value);
	}
	
	public static String decrypt(String value) throws Exception {
		return StringEncrypter.getEncrypter().decrypt(value);
	}
	
	public static String encrypt(String value, Key key) throws Exception {
		return StringEncrypter.getEncrypter().encrypt(value, key);
	}
	
	public static String decrypt(String value, Key key) throws Exception {
		return StringEncrypter.getEncrypter().decrypt(value, key);
	}
	
}
