package org.gcube.informationsystem.types.reference.entities;

import java.util.Set;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.impl.entities.EntityTypeImpl;
import org.gcube.informationsystem.types.reference.Type;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonDeserialize(as = EntityTypeImpl.class)
public interface EntityType extends Type, EntityElement {

	public static final String NAME = "EntityType"; //EntityType.class.getSimpleName();

	/* TypeDefinition is just a Java useful class. The type is not created in the IS. Hence the fields must be redefined */
	
	@Override
	@ISProperty(name = Type.NAME_PROPERTY, readonly = true, mandatory = true, nullable = false)
	public String getName();
	
	@Override
	@ISProperty(name = Type.DESCRIPTION_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public String getDescription();
	
	@Override
	@ISProperty(name = Type.ABSTRACT_PROPERTY, readonly = true, mandatory = true, nullable = false)
	public boolean isAbstract();

	@Override
	@ISProperty(name = Type.TYPE_SUPERCLASSES_PROPERTY, readonly = true, mandatory = true, nullable = false)
	public Set<String> getSuperClasses();

	/* TypeDefinition is just a Java useful class. The type is not created in the IS. Hence the fields must be redefined */
	
	
}
