/**
 * 
 */
package org.gcube.informationsystem.types.impl.properties;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.impl.properties.PropertyElementImpl;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=LinkedEntity.NAME)
public final class LinkedEntityImpl extends PropertyElementImpl implements LinkedEntity {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -531978995960170532L;
	
	protected String source;
	protected String relation;
	protected String target;
	protected String description;
	protected Integer min;
	protected Integer max;

	public LinkedEntityImpl() {
		super();
	}
	
	@Override
	public String getSource() {
		return source;
	}
	
	@Override
	public void setSource(String source) {
		this.source = source;
	}
	
	@Override
	public String getRelation() {
		return relation;
	}
	
	@Override
	public void setRelation(String relation) {
		this.relation = relation;
	} 

	@Override
	public String getTarget() {
		return target;
	}

	@Override
	public void setTarget(String target) {
		this.target = target;
	}
	
	@Override
	public String getDescription() {
		return description;
	}
	
	@Override
	public void setDescription(String description) {
		this.description = description;
	}
	
	@Override
	public Integer getMin() {
		return min;
	}
	
	@Override
	public void setMin(Integer min) {
		this.min = min;
	}
	
	@Override
	public Integer getMax() {
		return max;
	}
	
	@Override
	public void setMax(Integer max) {
		if(max==null || max<=0) {
			this.max = null;
		}else {
			this.max = max;
		}
	}
	
}
