package org.gcube.informationsystem.model.reference.properties;

import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.impl.properties.EncryptedImpl;
import org.gcube.informationsystem.types.annotations.ISProperty;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=EncryptedImpl.class)
public interface Encrypted extends Property {
	
	public static final String NAME = "Encrypted"; //Encrypted.class.getSimpleName();
	public static final String DESCRIPTION = "This is the base class for Encrypted values";
	public static final String VERSION = "1.0.0";
	
	public static final String VALUE = "value";
	
	@ISProperty(name=VALUE, readonly=false, mandatory=true, nullable=false)
	@JsonGetter(value=VALUE)
	public String getEncryptedValue();
	
	@JsonSetter(value=VALUE)
	public void setEncryptedValue(String encryptedValue);
	
}
