/**
 * 
 */
package org.gcube.informationsystem.model.reference.properties;

import java.util.Map;

import org.gcube.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.gcube.informationsystem.base.reference.SchemaMixedElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.model.impl.properties.PropertyImpl;
import org.gcube.informationsystem.utils.AdditionalPropertiesSerializer;

/**
 * @author Luca Frosini (ISTI - CNR)
 * Root Class for Property types. It creates a base common type, which is useful
 * for management purpose.
 */
// @JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(as=PropertyImpl.class)
public interface Property extends PropertyElement, SchemaMixedElement {
	
	public static final String NAME = "Property"; //Property.class.getSimpleName();
	public static final String DESCRIPTION = "This is the base class for Properties";
	public static final String VERSION = "1.0.0";
	
	@JsonAnyGetter
	@JsonSerialize(using = AdditionalPropertiesSerializer.class)
	@Override
	public Map<String,Object> getAdditionalProperties();
	
	@Override
	public void setAdditionalProperties(Map<String,Object> additionalProperties);
	
	@Override
	public Object getAdditionalProperty(String key);
	
	@JsonAnySetter
	@Override
	public void setAdditionalProperty(String key, Object value);
	
}
