/**
 * 
 */
package org.gcube.informationsystem.context.reference.relations;

import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.context.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.context.reference.entities.Context;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#isParentOf
 */
@JsonDeserialize(as = IsParentOfImpl.class)
public interface IsParentOf extends RelationElement<Context,Context> {
	
	public static final String NAME = "IsParentOf"; //IsParentOf.class.getSimpleName();
	
	@JsonIgnoreProperties({Context.PARENT_PROPERTY, Context.CHILDREN_PROPERTY})
	@JsonGetter(value = SOURCE_PROPERTY)
	public Context getSource();
	
	@JsonIgnore
	public void setSource(Context source);
	
	@JsonIgnoreProperties({Context.PARENT_PROPERTY, Context.CHILDREN_PROPERTY})
	@JsonGetter(value = TARGET_PROPERTY)
	public Context getTarget();
	
	@JsonIgnore
	public void setTarget(Context target);
	
}
