package org.gcube.informationsystem.base.reference.relations;

import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.annotations.ISProperty;

@Abstract
//@JsonDeserialize(as=RelationElementImpl.class) Do not uncomment to manage subclasses
public interface RelationElement<S extends EntityElement, T extends EntityElement> extends Element, IdentifiableElement {
	
	public static final String NAME = "RelationElement"; // RelationElement.class.getSimpleName();
	
	public static final String SOURCE_PROPERTY = "source";
	public static final String TARGET_PROPERTY = "target";
	
	/* Overriding getHeader method to create Header property in type */
	@ISProperty(name = HEADER_PROPERTY, mandatory = true, nullable = false)
	@Override
	public Header getHeader();
	
	@JsonGetter(value=SOURCE_PROPERTY)
	public S getSource();
	
	@JsonIgnore
	public void setSource(S source);
	
	@JsonGetter(value=TARGET_PROPERTY)
	public T getTarget();
	
	@JsonIgnore
	public void setTarget(T target);
	
}