package org.gcube.informationsystem.types.reference.properties;

import java.util.Set;

import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.impl.properties.PropertyTypeImpl;
import org.gcube.informationsystem.types.reference.Type;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonDeserialize(as = PropertyTypeImpl.class)
public interface PropertyType<P extends PropertyElement> extends PropertyElement, Type {
	
	public static final String NAME = "PropertyType"; // PropertyTypeDefinition.class.getSimpleName();
	
	@ISProperty(name=IdentifiableElement.HEADER_PROPERTY, mandatory=true, nullable=false)
	public Header getHeader();
	
	public void setHeader(Header header);
	
	/* TypeDefinition is just a Java useful class. The type is not created in the IS. Hence the fields must be redefined */
	
	@Override
	@ISProperty(name = Type.NAME_PROPERTY, readonly = true, mandatory = true, nullable = false)
	public String getName();
	
	@Override
	@ISProperty(name = Type.DESCRIPTION_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public String getDescription();
	
	@Override
	@ISProperty(name = Type.ABSTRACT_PROPERTY, readonly = true, mandatory = true, nullable = false)
	public boolean isAbstract();

	@Override
	@ISProperty(name = Type.TYPE_SUPERCLASSES_PROPERTY, readonly = true, mandatory = true, nullable = false)
	public Set<String> getSuperClasses();
	
	@ISProperty(name = Type.PROPERTIES_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public Set<PropertyDefinition> getProperties();
	
	/* TypeDefinition is just a Java useful class. The type is not created in the IS. Hence the fields must be redefined */
	
}
