/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.base.reference;

import java.util.Arrays;
import org.gcube.informationsystem.base.impl.entities.EntityElementImpl;
import org.gcube.informationsystem.base.impl.properties.PropertyElementImpl;
import org.gcube.informationsystem.base.impl.relations.RelationElementImpl;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.context.impl.entities.ContextImpl;
import org.gcube.informationsystem.context.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.context.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.impl.entities.DummyFacet;
import org.gcube.informationsystem.model.impl.entities.DummyResource;
import org.gcube.informationsystem.model.impl.entities.EntityImpl;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.informationsystem.model.impl.entities.ResourceImpl;
import org.gcube.informationsystem.model.impl.properties.DummyProperty;
import org.gcube.informationsystem.model.impl.properties.PropertyImpl;
import org.gcube.informationsystem.model.impl.relations.ConsistsOfImpl;
import org.gcube.informationsystem.model.impl.relations.DummyConsistsOf;
import org.gcube.informationsystem.model.impl.relations.DummyIsRelatedTo;
import org.gcube.informationsystem.model.impl.relations.IsRelatedToImpl;
import org.gcube.informationsystem.model.impl.relations.RelationImpl;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.types.impl.entities.EntityTypeImpl;
import org.gcube.informationsystem.types.impl.properties.PropertyDefinitionImpl;
import org.gcube.informationsystem.types.impl.properties.PropertyTypeImpl;
import org.gcube.informationsystem.types.impl.relations.RelationTypeImpl;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.types.reference.properties.PropertyType;
import org.gcube.informationsystem.types.reference.relations.RelationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AccessType {
    PROPERTY_ELEMENT(PropertyElement.class, "PropertyElement", PropertyElementImpl.class, null),
    PROPERTY(Property.class, "Property", PropertyImpl.class, DummyProperty.class),
    CONTEXT(Context.class, "Context", ContextImpl.class, null),
    IS_PARENT_OF(IsParentOf.class, "IsParentOf", IsParentOfImpl.class, null),
    PROPERTY_DEFINITION(PropertyDefinition.class, "PropertyDefinition", PropertyDefinitionImpl.class, null),
    PROPERTY_TYPE(PropertyType.class, "PropertyType", PropertyTypeImpl.class, null),
    ENTITY_TYPE(EntityType.class, "EntityType", EntityTypeImpl.class, null),
    RELATION_TYPE(RelationType.class, "RelationType", RelationTypeImpl.class, null),
    ENTITY_ELEMENT(EntityElement.class, "EntityElement", EntityElementImpl.class, null),
    ENTITY(Entity.class, "Entity", EntityImpl.class, null),
    RESOURCE(Resource.class, "Resource", ResourceImpl.class, DummyResource.class),
    FACET(Facet.class, "Facet", FacetImpl.class, DummyFacet.class),
    RELATION_ELEMENT(RelationElement.class, "RelationElement", RelationElementImpl.class, null),
    RELATION(Relation.class, "Relation", RelationImpl.class, null),
    IS_RELATED_TO(IsRelatedTo.class, "IsRelatedTo", IsRelatedToImpl.class, DummyIsRelatedTo.class),
    CONSISTS_OF(ConsistsOf.class, "ConsistsOf", ConsistsOfImpl.class, DummyConsistsOf.class);

    private static Logger logger;
    private final Class<? extends Element> clz;
    private final Class<? extends Element> implementationClass;
    private final Class<? extends Element> dummyImplementationClass;
    private final String name;
    private final String lowerCaseFirstCharacter;

    private <ISM extends Element, ISMC extends ISM, ISMD extends ISMC> AccessType(Class<ISM> clz, String name, Class<ISMC> implementationClass, Class<ISMD> dummyImplementationClass) {
        this.clz = clz;
        this.implementationClass = implementationClass;
        this.dummyImplementationClass = dummyImplementationClass;
        this.name = name;
        this.lowerCaseFirstCharacter = name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public <ISM extends Element> Class<ISM> getTypeClass() {
        return this.clz;
    }

    public <ISM extends Element, ISMC extends ISM> Class<ISMC> getImplementationClass() {
        return this.implementationClass;
    }

    public <ISM extends Element, ISMC extends ISM, ISMD extends ISMC> Class<ISMD> getDummyImplementationClass() {
        return this.dummyImplementationClass;
    }

    public String getName() {
        return this.name;
    }

    public String lowerCaseFirstCharacter() {
        return this.lowerCaseFirstCharacter;
    }

    public String toString() {
        return this.name;
    }

    public static AccessType getAccessType(Class<?> clz) {
        AccessType[] accessTypes;
        AccessType ret = null;
        for (AccessType accessType : accessTypes = AccessType.values()) {
            Class typeClass = accessType.getTypeClass();
            if (!typeClass.isAssignableFrom(clz) || ret != null && !ret.getTypeClass().isAssignableFrom(typeClass)) continue;
            ret = accessType;
        }
        if (ret != null) {
            return ret;
        }
        String error = String.format("The provided class %s does not belong to any of defined AccessTypes %s", clz.getSimpleName(), Arrays.toString((Object[])accessTypes));
        logger.trace(error);
        throw new RuntimeException(error);
    }

    static {
        logger = LoggerFactory.getLogger(AccessType.class);
    }
}

