package org.gcube.informationsystem.model.reference.entities;

import java.util.Map;

import org.gcube.informationsystem.base.reference.SchemaMixedElement;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.utils.AdditionalPropertiesSerializer;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Facets
 */
@Abstract
// @JsonDeserialize(as=FacetImpl.class) Do not uncomment to manage subclasses
public interface Facet extends Entity, SchemaMixedElement {
	
	public static final String NAME = "Facet"; //Facet.class.getSimpleName();
	public static final String DESCRIPTION = "This is the base class for Facets";
	public static final String VERSION = "1.0.0";
	
	@JsonAnyGetter
	@JsonSerialize(using = AdditionalPropertiesSerializer.class)
	@Override
	public Map<String,Object> getAdditionalProperties();
	
	@Override
	public void setAdditionalProperties(Map<String,Object> additionalProperties);
	
	@Override
	public Object getAdditionalProperty(String key);
	
	@JsonAnySetter
	@Override
	public void setAdditionalProperty(String key, Object value);
	
}
