package org.gcube.informationsystem.base.reference.entities;

import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.annotations.ISProperty;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@Abstract
@JsonIgnoreProperties(ignoreUnknown=true)
//@JsonDeserialize(as=EntityElementImpl.class) Do not uncomment to manage subclasses
public interface EntityElement extends Element, IdentifiableElement {
	
	public static final String NAME = "EntityElement"; //Entity.class.getSimpleName();

	/* Overriding getHeader method to create Header property in type */
	@ISProperty(name=HEADER_PROPERTY, mandatory=true, nullable=false)
	@Override
	public Header getHeader();
	
}