package org.gcube.informationsystem.types.reference.entities;

import java.util.List;

import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.impl.entities.ResourceTypeImpl;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(as=ResourceTypeImpl.class)
public interface ResourceType extends EntityType {
	
	public static final String NAME = "ResourceType"; //ResourceType.class.getSimpleName();
	public static final String DESCRIPTION = "Used to define a Resource Type";
	public static final String VERSION = "1.0.0";
	
	public static final String FACETS_PROPERTY = "facets";
	public static final String RESOURCES_PROPERTY = "resources";
	
	@ISProperty(name = FACETS_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public List<LinkedEntity> getFacets();
	
	@ISProperty(name = RESOURCES_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public List<LinkedEntity> getResources();
	
}
