package org.gcube.informationsystem.types.impl.properties;

import java.util.Set;

import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.types.impl.TypeImpl;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.types.reference.properties.PropertyType;

import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeName(value = PropertyType.NAME)
public final class PropertyTypeImpl<P extends PropertyElement> extends TypeImpl
		implements PropertyType<P> {
	
	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 7532701373450638829L;
	
	protected Set<PropertyDefinition> properties;
	
	protected PropertyTypeImpl() {
		super();
	}
	
	public PropertyTypeImpl(Class<P> clz) {
		super(clz);
		this.superClasses = retrieveSuperClasses(clz, PropertyElement.class,
				clz == PropertyElement.class ? null : PropertyElement.NAME);
	}
	
	@Override
	public Set<PropertyDefinition> getProperties() {
		return properties;
	}
	
}