/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.types.impl.TypeImpl;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.entities.FacetType;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.types.reference.properties.PropertyType;
import org.gcube.informationsystem.types.reference.relations.ConsistsOfType;
import org.gcube.informationsystem.types.reference.relations.IsRelatedToType;
import org.gcube.informationsystem.types.reference.relations.RelationType;

public class TypeMapper {
    private static final String NAME = "NAME";
    protected static final ObjectMapper mapper = new ObjectMapper();

    public static String serializeTypeDefinition(Type type) throws Exception {
        String json = mapper.writeValueAsString((Object)type);
        return json;
    }

    public static Type deserializeTypeDefinition(String json) throws Exception {
        Type type = (Type)mapper.readValue(json, Type.class);
        return type;
    }

    public static String serializeTypeDefinitions(List<Type> typeDefinitions) throws Exception {
        CollectionType javaType = mapper.getTypeFactory().constructCollectionType(List.class, Type.class);
        return mapper.writerFor((JavaType)javaType).writeValueAsString(typeDefinitions);
    }

    public static List<Type> deserializeTypeDefinitions(String json) throws Exception {
        CollectionType javaType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, Type.class);
        return (List)mapper.readValue(json, (JavaType)javaType);
    }

    public static <E extends Element> Type createTypeDefinition(Class<E> clz) {
        Type type = TypeImpl.getInstance(clz);
        return type;
    }

    public static <E extends Element> String serializeType(Class<E> clz) throws Exception {
        Type type = TypeMapper.createTypeDefinition(clz);
        return TypeMapper.serializeTypeDefinition(type);
    }

    public static String getType(Class<? extends Element> clz) {
        return TypeMapper.getStaticStringFieldByName(clz, NAME, clz.getSimpleName());
    }

    public static String getStaticStringFieldByName(Class<? extends Element> clz, String fieldName, String defaultValue) {
        try {
            Field field = clz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (String)field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return defaultValue;
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerSubtypes(new Class[]{Type.class});
        mapper.registerSubtypes(new Class[]{EntityType.class});
        mapper.registerSubtypes(new Class[]{ResourceType.class});
        mapper.registerSubtypes(new Class[]{FacetType.class});
        mapper.registerSubtypes(new Class[]{RelationType.class});
        mapper.registerSubtypes(new Class[]{IsRelatedToType.class});
        mapper.registerSubtypes(new Class[]{ConsistsOfType.class});
        mapper.registerSubtypes(new Class[]{PropertyType.class});
        mapper.registerSubtypes(new Class[]{PropertyDefinition.class});
        mapper.registerSubtypes(new Class[]{LinkedEntity.class});
    }
}

