/**
 * 
 */
package org.gcube.informationsystem.model.reference.relations;

import java.util.Map;

import org.gcube.informationsystem.base.reference.SchemaMixedElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.utils.AdditionalPropertiesSerializer;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Relations
 */
@Abstract
// @JsonDeserialize(as=RelationImpl.class) Do not uncomment to manage subclasses
public interface Relation<S extends Resource, T extends Entity> extends RelationElement<S,T>, SchemaMixedElement {
	
	public static final String NAME = "Relation"; //Relation.class.getSimpleName();
	
	public static final String PROPAGATION_CONSTRAINT = "propagationConstraint";
	
	@JsonIgnoreProperties({Resource.CONSISTS_OF_PROPERTY, Resource.IS_RELATED_TO_PROPERTY})
	@JsonGetter(value = SOURCE_PROPERTY)
	@Override
	public S getSource();
	
	@JsonIgnore
	@Override
	public void setSource(S source);
	
	@JsonGetter(value = TARGET_PROPERTY)
	@Override
	public T getTarget();
	
	@JsonIgnore
	@Override
	public void setTarget(T target);
	
	@ISProperty(name = PROPAGATION_CONSTRAINT)
	public PropagationConstraint getPropagationConstraint();
	
	@JsonAnyGetter
	@JsonSerialize(using = AdditionalPropertiesSerializer.class)
	@Override
	public Map<String,Object> getAdditionalProperties();
	
	@Override
	public void setAdditionalProperties(Map<String,Object> additionalProperties);
	
	@Override
	public Object getAdditionalProperty(String key);
	
	@JsonAnySetter
	@Override
	public void setAdditionalProperty(String key, Object value);
	
}
