/**
 * 
 */
package org.gcube.informationsystem.context.impl.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.gcube.informationsystem.base.impl.entities.EntityElementImpl;
import org.gcube.informationsystem.context.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.context.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=Context.NAME)
public final class ContextImpl extends EntityElementImpl implements Context {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -5070590328223454087L;
	
	protected String name;
	
	protected IsParentOf parent;
	protected List<IsParentOf> children;
	
	protected ContextImpl() {
		super();
		this.parent = null;
		this.children = new ArrayList<>();
	}
	
	public ContextImpl(String name) {
		this(name, null);
	}
	
	public ContextImpl(String name, UUID uuid) {
		this();
		this.name = name;
		if(uuid == null){
			uuid = UUID.randomUUID();
		}
		this.header = new HeaderImpl(uuid);
	}
	
	@Override
	public String getName() {
		return this.name;
	}

	@Override
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public IsParentOf getParent() {
		return parent;
	}
	
	
	@Override
	public void setParent(UUID uuid) {
		Context parent = null;
		if(uuid!=null) {
			parent = new ContextImpl();
			parent.setHeader(new HeaderImpl(uuid));
		}
		setParent(parent);
	}
	
	@Override
	public void setParent(Context context) {
		IsParentOf isParentOf = null;
		if(context!=null) {
			isParentOf = new IsParentOfImpl(context, this);
		}
		setParent(isParentOf);
	}
	
	@JsonSetter(value=PARENT_PROPERTY)
	protected void setParentFromJson(IsParentOf isParentOf) throws JsonProcessingException {
		if(isParentOf!=null) {
			Context parent = isParentOf.getSource();
			isParentOf.setTarget(this);
			((ContextImpl) parent).addChild(isParentOf);
		}
		setParent(isParentOf);
	}
	
	@Override
	public void setParent(IsParentOf isParentOf) {
		this.parent = isParentOf;
	}
	
	@Override
	public List<IsParentOf> getChildren() {
		return children;
	}

	@JsonSetter(value=CHILDREN_PROPERTY)
	protected void setChildrenFromJson(List<IsParentOf> children) throws JsonProcessingException {
		for(IsParentOf isParentOf : children){
			addChildFromJson(isParentOf);
		}
	}

	protected void addChildFromJson(IsParentOf isParentOf) throws JsonProcessingException {
		isParentOf.setSource(this);
		addChild(isParentOf);
	}
	
	@Override
	public void addChild(UUID uuid) {
		Context child = new ContextImpl();
		child.setHeader(new HeaderImpl(uuid));
		addChild(child);
	}
	
	@Override
	public void addChild(Context child) {
		IsParentOf isParentOf = new IsParentOfImpl(this, child);
		this.addChild(isParentOf);
	}
	
	@Override
	public void addChild(IsParentOf isParentOf) {
		((ContextImpl) isParentOf.getTarget()).setParent(this);
		children.add(isParentOf);
	}

}
