package org.gcube.informationsystem.types.impl.entities;

import java.util.ArrayList;
import java.util.List;

import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaEntry;
import org.gcube.informationsystem.types.annotations.ResourceSchemaRelatedEntry;
import org.gcube.informationsystem.types.impl.properties.LinkedEntityImpl;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;

import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=ResourceType.NAME)
public class ResourceTypeImpl extends EntityTypeImpl implements ResourceType {
	
	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -5964819173421808432L;
	
	protected List<LinkedEntity> facets;
	protected List<LinkedEntity> resources;
	
	protected ResourceTypeImpl() {
		super();
	}
	
	public ResourceTypeImpl(Class<? extends Resource> clz) {
		super(clz);
		
		this.superClasses = retrieveSuperClasses(clz, Resource.class, Entity.NAME);
		
		setResourceSchemaEntries(clz);
	}
	
	private void setResourceSchemaEntries(Class<? extends Resource> clz){
		if(clz.isAnnotationPresent(ResourceSchema.class)) {
			this.facets = new ArrayList<>();
			this.resources = new ArrayList<>();
			ResourceSchema[] resourceSchemaArray = clz.getAnnotationsByType(ResourceSchema.class);
			for(ResourceSchemaEntry resourceSchemaEntry : resourceSchemaArray[0].facets()) {
				LinkedEntityImpl resourceSchemaEntryDefinition = new LinkedEntityImpl();
				resourceSchemaEntryDefinition.setSource(TypeMapper.getType(clz));
				resourceSchemaEntryDefinition.setRelation(TypeMapper.getType(resourceSchemaEntry.relation()));
				resourceSchemaEntryDefinition.setTarget(TypeMapper.getType(resourceSchemaEntry.facet()));
				resourceSchemaEntryDefinition.setDescription(resourceSchemaEntry.description());
				resourceSchemaEntryDefinition.setMin(resourceSchemaEntry.min());
				resourceSchemaEntryDefinition.setMax(resourceSchemaEntry.max());
				this.facets.add(resourceSchemaEntryDefinition);
			}
			for(ResourceSchemaRelatedEntry resourceSchemaRelatedEntry : resourceSchemaArray[0].resources()) {
				LinkedEntity resourceSchemaEntryDefinition = new LinkedEntityImpl();
				resourceSchemaEntryDefinition.setSource(TypeMapper.getType(resourceSchemaRelatedEntry.source()));
				resourceSchemaEntryDefinition.setRelation(TypeMapper.getType(resourceSchemaRelatedEntry.relation()));
				resourceSchemaEntryDefinition.setTarget(TypeMapper.getType(resourceSchemaRelatedEntry.target()));
				resourceSchemaEntryDefinition.setDescription(resourceSchemaRelatedEntry.description());
				resourceSchemaEntryDefinition.setMin(resourceSchemaRelatedEntry.min());
				resourceSchemaEntryDefinition.setMax(resourceSchemaRelatedEntry.max());
				this.resources.add(resourceSchemaEntryDefinition);
			}
		}
	}
	
	@Override
	public List<LinkedEntity> getFacets() {
		return facets;
	}
	
	@Override
	public List<LinkedEntity> getResources() {
		return resources;
	}
	
}
