/**
 * 
 */
package org.gcube.informationsystem.base.reference;

import java.io.Serializable;

import org.gcube.informationsystem.types.annotations.Abstract;

import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@Abstract
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = Element.CLASS_PROPERTY)
public interface Element extends Serializable {

	public static final String NAME = "Element"; //Element.class.getSimpleName();
	
	public static final String CLASS_PROPERTY = "@class";
	
	public static final String SUPERCLASSES_PROPERTY = "@superClasses";
	
	/**
	 * DateTime Pattern to be used to serialize Dates in every element 
	 */
	public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
	
}
