/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.utils.ElementDeserializer;
import org.gcube.informationsystem.utils.ElementMappingAction;
import org.gcube.informationsystem.utils.discovery.ElementSpecilizationDiscovery;
import org.gcube.informationsystem.utils.discovery.RegistrationProvider;
import org.gcube.informationsystem.utils.discovery.SchemaAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElementMapper {
    private static Logger logger;
    protected static final ObjectMapper mapper;

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static void registerPackages(List<Package> packages) {
        ElementMappingAction schemaAction = new ElementMappingAction();
        try {
            ElementSpecilizationDiscovery.manageISM((SchemaAction)schemaAction, packages);
        }
        catch (Exception e) {
            logger.error("Error registering types", (Throwable)e);
        }
    }

    public static void registerPackages(Package ... packages) {
        ElementMappingAction schemaAction = new ElementMappingAction();
        try {
            ElementSpecilizationDiscovery.manageISM((SchemaAction)schemaAction, packages);
        }
        catch (Exception e) {
            logger.error("Error registering types", (Throwable)e);
        }
    }

    public static <El extends Element> void registerSubtypes(Class<El> ... classes) {
        mapper.registerSubtypes((Class[])classes);
    }

    public static <T extends OutputStream, ISM extends Element> T marshal(ISM object, T stream) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(stream, object);
        return stream;
    }

    public static <T extends Writer, ISM extends Element> T marshal(ISM object, T writer) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(writer, object);
        return writer;
    }

    public static <El extends Element> String marshal(El object) throws JsonProcessingException {
        return mapper.writeValueAsString(object);
    }

    public static <El extends Element> String marshal(List<El> list) throws JsonProcessingException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, Element.class);
        return mapper.writerFor((JavaType)type).writeValueAsString(list);
    }

    public static <El extends Element> String marshal(El[] array) throws JsonProcessingException {
        return mapper.writeValueAsString(array);
    }

    public static <El extends Element> El unmarshal(Class<El> clz, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        return (El)((Element)mapper.readValue(reader, clz));
    }

    public static <El extends Element> El unmarshal(Class<El> clz, InputStream stream) throws JsonParseException, JsonMappingException, IOException {
        return (El)((Element)mapper.readValue(stream, clz));
    }

    public static <ISM extends Element> ISM unmarshal(Class<ISM> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        return (ISM)((Element)mapper.readValue(string, clz));
    }

    public static <ISM extends Element> ISM unmarshalWithReader(Class<ISM> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        return (ISM)((Element)mapper.readerFor(clz).readValue(string));
    }

    public static <ISM extends Element> List<ISM> unmarshalList(Class<ISM> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, clz);
        return (List)mapper.readValue(string, (JavaType)type);
    }

    public static <ISM extends Element> List<ISM> unmarshalList(String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, Element.class);
        return (List)mapper.readValue(string, (JavaType)type);
    }

    static {
        AccessType[] accessTypes;
        logger = LoggerFactory.getLogger(ElementMapper.class);
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ArrayList<Package> packages = new ArrayList<Package>();
        for (AccessType accessType : accessTypes = AccessType.values()) {
            Class clz = accessType.getTypeClass();
            if (Type.class.isAssignableFrom(clz)) continue;
            Class dummyClz = accessType.getDummyImplementationClass();
            if (dummyClz != null) {
                SimpleModule isModule = new SimpleModule(accessType.getName());
                isModule.addDeserializer(clz, new ElementDeserializer(clz, mapper));
                mapper.registerModule((Module)isModule);
                ElementMapper.registerSubtypes(dummyClz);
            }
            packages.add(clz.getPackage());
        }
        ElementMapper.registerPackages(packages);
        ServiceLoader<RegistrationProvider> regsitrationProviders = ServiceLoader.load(RegistrationProvider.class);
        for (RegistrationProvider registrationProvider : regsitrationProviders) {
            ElementMapper.registerPackages(registrationProvider.getPackagesToRegister());
        }
    }
}

