/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.properties.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utility {
    private static Logger logger = LoggerFactory.getLogger(Utility.class);

    public static UUID getUUIDFromJsonNode(JsonNode jsonNode) {
        JsonNode header = jsonNode.get("header");
        UUID uuid = UUID.fromString(header.get("uuid").asText());
        logger.trace("UUID got from {} is : {} ", (Object)jsonNode.toString(), (Object)uuid);
        return uuid;
    }

    public static UUID getUUIDFromJSONString(String json) throws JsonProcessingException, IOException {
        logger.trace("Trying to get UUID from {} of {} ", (Object)Header.class.getSimpleName(), (Object)json);
        JsonNode jsonNode = Utility.getJSONNode(json);
        return Utility.getUUIDFromJsonNode(jsonNode);
    }

    public static JsonNode getJSONNode(String json) throws JsonProcessingException, IOException {
        if (json == null || json.compareTo("") == 0) {
            return null;
        }
        logger.trace("Trying to get Jsonnode from {}", (Object)json);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(json);
        return jsonNode;
    }
}

