/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl.properties;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.properties.BaseProperty;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.types.Type;
import org.gcube.informationsystem.types.TypeBinder;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.impl.TypeDefinitionImpl;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="PropertyDefinition")
public final class PropertyDefinitionImpl
implements PropertyDefinition {
    private static final long serialVersionUID = -5925314595659292025L;
    private static Logger logger = LoggerFactory.getLogger(TypeDefinitionImpl.class);
    public static final String UUID_PATTERN = "^([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}){1}$";
    public static final String URI_PATTERN = null;
    public static final String URL_PATTERN = null;
    private String name = "";
    private String description = "";
    private boolean mandatory = false;
    private boolean readonly = false;
    private boolean notnull = false;
    private Integer max = null;
    private Integer min = null;
    private String regexp = null;
    private Integer linkedType = null;
    private String linkedClass = null;
    private Integer type = null;

    private static String getPropertyNameFromMethodName(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.replace("get", "");
        }
        if (name.startsWith("is")) {
            name = name.replace("is", "");
        }
        if (name.length() > 0) {
            name = Character.toLowerCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        }
        return name;
    }

    public PropertyDefinitionImpl(ISProperty propertyAnnotation, Method method) {
        String name;
        this.name = name = propertyAnnotation.name().isEmpty() ? PropertyDefinitionImpl.getPropertyNameFromMethodName(method) : propertyAnnotation.name();
        this.description = propertyAnnotation.description();
        this.mandatory = propertyAnnotation.mandatory();
        this.notnull = !propertyAnnotation.nullable();
        this.readonly = propertyAnnotation.readonly();
        if (propertyAnnotation.max() > 0) {
            this.max = propertyAnnotation.max();
        }
        if (propertyAnnotation.max() >= propertyAnnotation.min() && propertyAnnotation.min() > 0) {
            this.min = propertyAnnotation.min();
        }
        if (!propertyAnnotation.regexpr().isEmpty()) {
            this.regexp = propertyAnnotation.regexpr();
        }
        logger.trace("Looking for property type {}", method.getReturnType());
        Class<?> type = method.getReturnType();
        this.type = Type.OType.PROPERTY.getIntValue();
        if (BaseProperty.class.isAssignableFrom(type)) {
            if (type != Property.class) {
                this.linkedClass = TypeBinder.getType(type);
            }
        } else if (Type.getTypeByClass(type) != null) {
            this.type = Type.getTypeByClass(type).getIntValue();
            if (this.type > 9 && this.type <= 12) {
                java.lang.reflect.Type genericReturnType = method.getGenericReturnType();
                logger.trace("Generic Return Type {} for method {}", (Object)genericReturnType, (Object)method);
                java.lang.reflect.Type[] actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments();
                java.lang.reflect.Type genericType = null;
                for (java.lang.reflect.Type t : actualTypeArguments) {
                    logger.trace("Generic Return Type {} for method {} - Actual Type Argument : {}", new Object[]{genericReturnType, method, t});
                    genericType = t;
                }
                Class genericClass = (Class)genericType;
                Type.OType linkedOType = Type.getTypeByClass(genericClass);
                if (linkedOType != null) {
                    this.linkedType = linkedOType.getIntValue();
                } else {
                    this.linkedClass = TypeBinder.getType(genericClass);
                }
            }
            if ((this.regexp == null || this.regexp.compareTo("") == 0) && this.type.intValue() == Type.OType.STRING.getIntValue()) {
                if (Enum.class.isAssignableFrom(type)) {
                    ?[] constants = type.getEnumConstants();
                    StringBuilder stringBuilder = new StringBuilder("^(");
                    for (int i = 0; i < constants.length; ++i) {
                        stringBuilder.append(constants[i].toString());
                        if (i >= constants.length - 1) continue;
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(")$");
                    this.regexp = stringBuilder.toString();
                }
                if (UUID.class.isAssignableFrom(type)) {
                    this.regexp = UUID_PATTERN;
                }
                if (URI.class.isAssignableFrom(type)) {
                    this.regexp = URI_PATTERN;
                }
                if (URL.class.isAssignableFrom(type)) {
                    this.regexp = URL_PATTERN;
                }
            }
            if (this.regexp != null && this.regexp.compareTo("") == 0) {
                this.regexp = null;
            }
        } else {
            throw new RuntimeException("Type " + type.getSimpleName() + " not reconized");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public boolean isNotnull() {
        return this.notnull;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public Integer getMin() {
        return this.min;
    }

    @Override
    public String getRegexp() {
        return this.regexp;
    }

    @Override
    public Integer getLinkedType() {
        return this.linkedType;
    }

    @Override
    public String getLinkedClass() {
        return this.linkedClass;
    }

    @Override
    public Integer getType() {
        return this.type;
    }

    @JsonIgnore
    public String getTypeStringValue() {
        if (this.type == null) {
            return null;
        }
        return Type.OType.values()[this.type].getStringValue();
    }

    public String toString() {
        return "Property [name=" + this.name + ", description=" + this.description + ", mandatory=" + this.mandatory + ", readonly=" + this.readonly + ", notnull=" + this.notnull + ", max=" + this.max + ", min=" + this.min + ", regexpr=" + this.regexp + ", type = " + this.type + " (" + this.getTypeStringValue() + "), linkedType = " + this.linkedType + ", linkedClass = " + this.linkedClass + "]";
    }
}

