/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Set;
import org.gcube.informationsystem.base.impl.ISManageableImpl;
import org.gcube.informationsystem.base.reference.ISManageable;
import org.gcube.informationsystem.base.reference.entities.BaseEntity;
import org.gcube.informationsystem.base.reference.properties.BaseProperty;
import org.gcube.informationsystem.base.reference.relations.BaseRelation;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.types.TypeBinder;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.impl.entities.EntityTypeDefinitionImpl;
import org.gcube.informationsystem.types.impl.properties.PropertyDefinitionImpl;
import org.gcube.informationsystem.types.impl.properties.PropertyTypeDefinitionImpl;
import org.gcube.informationsystem.types.impl.relations.RelationTypeDefinitionImpl;
import org.gcube.informationsystem.types.reference.TypeDefinition;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="TypeDefinition")
public class TypeDefinitionImpl<ISM extends ISManageable>
extends ISManageableImpl
implements TypeDefinition<ISM> {
    private static final long serialVersionUID = 2698204820689338513L;
    private static Logger logger = LoggerFactory.getLogger(TypeDefinitionImpl.class);
    public static final String DESCRIPTION = "DESCRIPTION";
    protected String name;
    protected String description;
    @JsonProperty(value="abstract")
    protected boolean abstractType;
    protected Set<String> superClasses;
    protected Set<PropertyDefinition> properties;

    protected static <ISM extends ISManageable> Set<String> retrieveSuperClasses(Class<? extends ISM> type, Class<ISM> baseClass, String topSuperClass) {
        Class<?>[] interfaces;
        HashSet<String> interfaceList = new HashSet<String>();
        if (type == baseClass) {
            if (topSuperClass != null) {
                interfaceList.add(topSuperClass);
            }
            return interfaceList;
        }
        for (Class<?> interfaceClass : interfaces = type.getInterfaces()) {
            if (!baseClass.isAssignableFrom(interfaceClass)) continue;
            Class<?> clz = interfaceClass;
            interfaceList.add(TypeBinder.getType(clz));
        }
        return interfaceList;
    }

    private static Set<PropertyDefinition> retrieveListOfProperties(Class<?> type) {
        HashSet<PropertyDefinition> properties = new HashSet<PropertyDefinition>();
        for (Method m : type.getDeclaredMethods()) {
            m.setAccessible(true);
            if (!m.isAnnotationPresent(ISProperty.class) || m.isBridge()) continue;
            ISProperty propAnnotation = m.getAnnotation(ISProperty.class);
            PropertyDefinitionImpl prop = new PropertyDefinitionImpl(propAnnotation, m);
            properties.add(prop);
            logger.trace("Property {} retrieved in type {} ", (Object)prop, (Object)type.getSimpleName());
        }
        return properties;
    }

    protected static Class<?> getGenericClass(Type type) {
        TypeVariable typeVariable = (TypeVariable)type;
        Type[] bounds = typeVariable.getBounds();
        Type t = bounds[0];
        return (Class)t;
    }

    public static <ISM extends ISManageable> TypeDefinition<ISM> getInstance(Class<ISM> clz) {
        if (BaseEntity.class.isAssignableFrom(clz)) {
            return new EntityTypeDefinitionImpl<ISM>(clz);
        }
        if (BaseRelation.class.isAssignableFrom(clz)) {
            return new RelationTypeDefinitionImpl(clz);
        }
        if (BaseProperty.class.isAssignableFrom(clz)) {
            return new PropertyTypeDefinitionImpl<ISM>(clz);
        }
        if (TypeDefinition.class.isAssignableFrom(clz)) {
            return new TypeDefinitionImpl<ISM>(clz);
        }
        throw new RuntimeException("Serialization required");
    }

    protected TypeDefinitionImpl(Class<ISM> clz) {
        this.name = TypeBinder.getType(clz);
        this.description = TypeBinder.getStaticStringFieldByName(clz, DESCRIPTION, "");
        this.abstractType = false;
        if (clz.isAnnotationPresent(Abstract.class)) {
            this.abstractType = true;
        }
        if (!Resource.class.isAssignableFrom(clz)) {
            this.properties = TypeDefinitionImpl.retrieveListOfProperties(clz);
        }
        logger.trace("{} : {} ", clz, (Object)this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isAbstract() {
        return this.abstractType;
    }

    @Override
    public Set<String> getSuperClasses() {
        return this.superClasses;
    }

    @Override
    public Set<PropertyDefinition> getProperties() {
        return this.properties;
    }
}

