/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.gcube.informationsystem.base.reference.ISManageable;
import org.gcube.informationsystem.types.impl.TypeDefinitionImpl;
import org.gcube.informationsystem.types.reference.TypeDefinition;
import org.gcube.informationsystem.utils.ISMapper;

public class TypeBinder {
    private static final String NAME = "NAME";

    public static <ISM extends ISManageable> String serializeTypeDefinition(TypeDefinition<ISM> typeDefinition) throws Exception {
        String json = ISMapper.marshal(typeDefinition);
        return json;
    }

    public static <ISM extends ISManageable> String serializeType(Class<ISM> type) throws Exception {
        TypeDefinition<ISM> typeDefinition = TypeBinder.createTypeDefinition(type);
        return ISMapper.marshal(typeDefinition);
    }

    public static <ISM extends ISManageable> TypeDefinition<ISM> deserializeTypeDefinition(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        TypeDefinition readValue = (TypeDefinition)mapper.readValue(json, TypeDefinition.class);
        return readValue;
    }

    public static <ISM extends ISManageable> String serializeTypeDefinitions(List<TypeDefinition<ISM>> typeDefinitions) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(typeDefinitions);
        return json;
    }

    public static <ISM extends ISManageable> List<TypeDefinition<ISM>> deserializeTypeDefinitions(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, TypeDefinition.class);
        return (List)mapper.readValue(json, (JavaType)type);
    }

    public static <ISM extends ISManageable> TypeDefinition<ISM> createTypeDefinition(Class<ISM> clz) {
        TypeDefinition<ISM> typeDefinition = TypeDefinitionImpl.getInstance(clz);
        return typeDefinition;
    }

    public static String getType(Class<? extends ISManageable> clz) {
        return TypeBinder.getStaticStringFieldByName(clz, NAME, clz.getSimpleName());
    }

    public static String getStaticStringFieldByName(Class<? extends ISManageable> type, String fieldName, String defaultValue) {
        try {
            Field field = type.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (String)field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return defaultValue;
        }
    }
}

