/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl.relations;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.StringWriter;
import java.lang.reflect.TypeVariable;
import org.gcube.informationsystem.base.reference.entities.BaseEntity;
import org.gcube.informationsystem.base.reference.properties.Header;
import org.gcube.informationsystem.base.reference.relations.BaseRelation;
import org.gcube.informationsystem.context.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.types.TypeBinder;
import org.gcube.informationsystem.types.impl.TypeDefinitionImpl;
import org.gcube.informationsystem.types.reference.TypeDefinition;
import org.gcube.informationsystem.types.reference.entities.EntityTypeDefinition;
import org.gcube.informationsystem.types.reference.relations.RelationTypeDefinition;
import org.gcube.informationsystem.utils.ISMapper;

@JsonTypeName(value="RelationTypeDefinition")
public class RelationTypeDefinitionImpl<Out extends BaseEntity, In extends BaseEntity, Rel extends BaseRelation<Out, In>>
extends TypeDefinitionImpl<Rel>
implements RelationTypeDefinition<Out, In, Rel> {
    private static final long serialVersionUID = 2221831081869571296L;
    private static final String EDGE_CLASS_NAME = "E";
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String sourceType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String targetType;
    protected Header header;
    protected EntityTypeDefinition<Out> source;
    protected EntityTypeDefinition<In> target;

    public RelationTypeDefinitionImpl(Class<Rel> clz) {
        super(clz);
        Class<Rel> c;
        if (IsRelatedTo.class.isAssignableFrom(clz)) {
            c = clz;
            this.superClasses = RelationTypeDefinitionImpl.retrieveSuperClasses(c, IsRelatedTo.class, "Relation");
        } else if (ConsistsOf.class.isAssignableFrom(clz)) {
            c = clz;
            this.superClasses = RelationTypeDefinitionImpl.retrieveSuperClasses(c, ConsistsOf.class, "Relation");
        } else if (RelationTypeDefinition.class.isAssignableFrom(clz)) {
            this.superClasses = RelationTypeDefinitionImpl.retrieveSuperClasses(clz, BaseRelation.class, EDGE_CLASS_NAME);
            this.superClasses.add(TypeDefinition.class.getSimpleName());
        } else if (IsParentOf.class.isAssignableFrom(clz)) {
            this.superClasses = RelationTypeDefinitionImpl.retrieveSuperClasses(clz, BaseRelation.class, EDGE_CLASS_NAME);
        } else {
            throw new RuntimeException("Type Hierachy Error");
        }
        TypeVariable<Class<Rel>>[] typeParameters = clz.getTypeParameters();
        Class<?> sourceClass = RelationTypeDefinitionImpl.getGenericClass(typeParameters[0]);
        Class<?> targetClass = RelationTypeDefinitionImpl.getGenericClass(typeParameters[1]);
        this.sourceType = TypeBinder.getType(sourceClass);
        this.targetType = TypeBinder.getType(targetClass);
    }

    @Override
    public String getSourceType() {
        return this.sourceType;
    }

    @Override
    public String getTargetType() {
        return this.targetType;
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(Header header) {
        this.header = header;
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            ISMapper.marshal(this, stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            try {
                ISMapper.marshal(this.header, stringWriter);
                return stringWriter.toString();
            }
            catch (Exception e1) {
                return super.toString();
            }
        }
    }

    @Override
    public EntityTypeDefinition<Out> getSource() {
        return this.source;
    }

    @Override
    public void setSource(EntityTypeDefinition<Out> source) {
        this.source = source;
    }

    @Override
    public EntityTypeDefinition<In> getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(EntityTypeDefinition<In> target) {
        this.target = target;
    }
}

