/**
 * 
 */
package org.gcube.informationsystem.utils;

import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.utils.discovery.SchemaAction;

import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
class ObjectMappingERAction implements SchemaAction {

	protected ObjectMapper objectMapper;
	
	public ObjectMappingERAction(ObjectMapper objectMapper){
		this.objectMapper = objectMapper;
	}
	
	@Override
	public <E extends Property> void managePropertyClass(Class<E> e)
			throws Exception {
		objectMapper.registerSubtypes(e);
	}

	@Override
	public <E extends Entity> void manageEntityClass(Class<E> e)
			throws Exception {
		objectMapper.registerSubtypes(e);
	}

	@Override
	public <R extends Relation<? extends Entity, ? extends Entity>> void manageRelationClass(
			Class<R> r) throws Exception {
		objectMapper.registerSubtypes(r);
	}

}
