package org.gcube.informationsystem.types.reference.relations;

import org.gcube.informationsystem.base.reference.entities.BaseEntity;
import org.gcube.informationsystem.base.reference.relations.BaseRelation;
import org.gcube.informationsystem.types.impl.relations.RelationTypeDefinitionImpl;
import org.gcube.informationsystem.types.reference.TypeDefinition;
import org.gcube.informationsystem.types.reference.entities.EntityTypeDefinition;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonDeserialize(as = RelationTypeDefinitionImpl.class)
public interface RelationTypeDefinition<Out extends BaseEntity, In extends BaseEntity, Rel extends BaseRelation<Out,In>>
		extends TypeDefinition<Rel>, BaseRelation<EntityTypeDefinition<Out>,EntityTypeDefinition<In>> {
	
	public static final String NAME = "RelationTypeDefinition"; // PropertyTypeDefiniton.class.getSimpleName();
	
	public String getSourceType();
	
	public String getTargetType();
	
}
