package org.gcube.informationsystem.types.reference;

import java.util.Set;

import org.gcube.informationsystem.base.reference.ER;
import org.gcube.informationsystem.base.reference.ISManageable;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@Abstract
@JsonIgnoreProperties(ignoreUnknown=true)
//@JsonDeserialize(as=TypeDefinitionImpl.class) Do not uncomment to manage subclasses
public interface TypeDefinition<ISM extends ISManageable> extends ER {
	
	public static final String NAME = "TypeDefinition"; //Entity.class.getSimpleName();
	
	public String getName();

	public String getDescription();

	public boolean isAbstract();

	public Set<String> getSuperClasses();

	public Set<PropertyDefinition> getProperties();
	
}
