package org.gcube.informationsystem.types.impl.relations;

import org.gcube.informationsystem.base.reference.entities.BaseEntity;
import org.gcube.informationsystem.base.reference.relations.BaseRelation;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.types.TypeBinder;
import org.gcube.informationsystem.types.impl.TypeDefinitionImpl;
import org.gcube.informationsystem.types.reference.entities.EntityTypeDefinition;
import org.gcube.informationsystem.types.reference.relations.RelationTypeDefinition;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeName(value=RelationTypeDefinition.NAME)
public class RelationTypeDefinitionImpl<Out extends BaseEntity, In extends BaseEntity, Rel extends BaseRelation<Out,In>>
		extends TypeDefinitionImpl<Rel> implements RelationTypeDefinition<Out,In,Rel> {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 2221831081869571296L;
	
	private static final String EDGE_CLASS_NAME   = "E";
	
	@JsonInclude(JsonInclude.Include.NON_NULL) 
	protected String sourceType;
	@JsonInclude(JsonInclude.Include.NON_NULL) 
	protected String targetType;
	
	public RelationTypeDefinitionImpl(Class<Rel> clz) {
		super(clz);
		
		if(IsRelatedTo.class.isAssignableFrom(clz)){
			@SuppressWarnings({"unchecked", "rawtypes"})
			Class<? extends IsRelatedTo> c = (Class<? extends IsRelatedTo>) clz;
			this.superClasses = retrieveSuperClasses(c, IsRelatedTo.class, Relation.NAME);
		} else if(ConsistsOf.class.isAssignableFrom(clz)) {
			@SuppressWarnings({"unchecked", "rawtypes"})
			Class<? extends ConsistsOf> c = (Class<? extends ConsistsOf>) clz;
			this.superClasses = retrieveSuperClasses(c, ConsistsOf.class, Relation.NAME);
		} else {
			this.superClasses = retrieveSuperClasses(clz, BaseRelation.class, EDGE_CLASS_NAME);
		}
		
		java.lang.reflect.Type[] typeParameters = clz.getTypeParameters();
		@SuppressWarnings("unchecked")
		Class<Out> sourceClass = (Class<Out>) getGenericClass(typeParameters[0]);
		@SuppressWarnings("unchecked")
		Class<In> targetClass = (Class<In>) getGenericClass(typeParameters[1]);
		
		this.sourceType = TypeBinder.getType(sourceClass);
		this.targetType = TypeBinder.getType(targetClass);
	}

	
	public String getSourceType() {
		return sourceType;
	}
	
	public String getTargetType() {
		return targetType;
	}
	
	@Override
	public EntityTypeDefinition<Out> getSource() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setSource(EntityTypeDefinition<Out> source) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public EntityTypeDefinition<In> getTarget() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setTarget(EntityTypeDefinition<In> target) {
		// TODO Auto-generated method stub
		
	}
	
}
