package org.gcube.informationsystem.types.impl.entities;

import org.gcube.informationsystem.base.reference.entities.BaseEntity;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.types.impl.TypeDefinitionImpl;
import org.gcube.informationsystem.types.reference.entities.EntityTypeDefinition;

import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeName(value=EntityTypeDefinition.NAME)
public class EntityTypeDefinitionImpl<E extends BaseEntity> extends TypeDefinitionImpl<E> implements EntityTypeDefinition<E> {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 2614315845213942880L;

	private static final String VERTEX_CLASS_NAME = "V";
	
	public EntityTypeDefinitionImpl(Class<E> clz) {
		super(clz);
		
		if(Resource.class.isAssignableFrom(clz)){
			@SuppressWarnings({"unchecked"})
			Class<? extends Resource> c = (Class<? extends Resource>) clz;
			this.superClasses = retrieveSuperClasses(c, Resource.class, Entity.NAME);
		} else if(Facet.class.isAssignableFrom(clz)){
			@SuppressWarnings({"unchecked"})
			Class<? extends Facet> c = (Class<? extends Facet>) clz;
			this.superClasses = retrieveSuperClasses(c, Facet.class, Entity.NAME);
		} else {
			this.superClasses = retrieveSuperClasses(clz, BaseEntity.class, VERTEX_CLASS_NAME);
		}
		
		
	}

}
