package org.gcube.informationsystem.types;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import org.gcube.informationsystem.base.reference.ISManageable;
import org.gcube.informationsystem.types.impl.TypeDefinitionImpl;
import org.gcube.informationsystem.types.reference.TypeDefinition;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class TypeBinder {

	private final static String NAME = "NAME";
	
	public static <ISM extends ISManageable> String serializeTypeDefinition(TypeDefinition<ISM> typeDefinition) throws Exception{
		ObjectMapper mapper = new ObjectMapper();
		String json = mapper.writeValueAsString(typeDefinition);
		return json;
	}
	
	public static <ISM extends ISManageable> String serializeType(Class<ISM> type) throws Exception{
		TypeDefinition<ISM> typeDefinition = createTypeDefinition(type);
		return serializeTypeDefinition(typeDefinition);
	}

	public static <ISM extends ISManageable> TypeDefinition<ISM> deserializeTypeDefinition(String json) throws Exception{
		ObjectMapper mapper = new ObjectMapper();
		@SuppressWarnings("unchecked")
		TypeDefinition<ISM> readValue = mapper.readValue(json, TypeDefinition.class);
		return readValue;
	}
	
	public static <ISM extends ISManageable> String serializeTypeDefinitions(List<TypeDefinition<ISM>> typeDefinitions) throws Exception{
		ObjectMapper mapper = new ObjectMapper();
		String json = mapper.writeValueAsString(typeDefinitions);
		return json;
	}
	
	public static <ISM extends ISManageable> List<TypeDefinition<ISM>> deserializeTypeDefinitions(String json) throws Exception{
		ObjectMapper mapper = new ObjectMapper();
		JavaType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, TypeDefinition.class) ;
		return mapper.readValue(json, type);
	}
	
	public static <ISM extends ISManageable> TypeDefinition<ISM> createTypeDefinition(Class<ISM> clz) {
		TypeDefinition<ISM> typeDefinition = TypeDefinitionImpl.getInstance(clz);
		return typeDefinition;
	}
	
	public static String getType(Class<? extends ISManageable> clz){
		return getStaticStringFieldByName(clz, NAME, clz.getSimpleName());
	}
	
	public static String getStaticStringFieldByName(Class<? extends ISManageable> type, String fieldName, String defaultValue){
		Field field;
		try {
			field = type.getDeclaredField(fieldName);
			field.setAccessible(true);
			return (String) field.get(null);
		} catch (NoSuchFieldException | SecurityException | IllegalArgumentException | IllegalAccessException e) {
			return defaultValue;
		}
	}
}
