/**
 * 
 */
package org.gcube.informationsystem.model.reference.entities;

import org.gcube.informationsystem.base.reference.entities.BaseEntity;
import org.gcube.informationsystem.base.reference.properties.Header;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.annotations.ISProperty;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;


/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Basic_Concepts
 */
@Abstract
@JsonIgnoreProperties(ignoreUnknown=true)
//@JsonDeserialize(as=EntityImpl.class) Do not uncomment to manage subclasses
public interface Entity extends BaseEntity {
	
	public static final String NAME = "Entity"; //Entity.class.getSimpleName();
	
	/* Overriding getHeader method to create Header property in type */
	@ISProperty(name=HEADER_PROPERTY, mandatory=true, nullable=false)
	@Override
	public Header getHeader();
	
}
