/**
 * 
 */
package org.gcube.informationsystem.context.reference.relations;

import org.gcube.informationsystem.base.reference.properties.Header;
import org.gcube.informationsystem.base.reference.relations.BaseRelation;
import org.gcube.informationsystem.context.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.types.annotations.ISProperty;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#isParentOf
 */
@JsonDeserialize(as = IsParentOfImpl.class)
public interface IsParentOf<Out extends Context, In extends Context> extends BaseRelation<Out,In> {
	
	public static final String NAME = "IsParentOf"; //IsParentOf.class.getSimpleName();
	
	/* Overriding getHeader method to create Header property in type */
	@ISProperty(name = HEADER_PROPERTY, mandatory = true, nullable = false)
	@Override
	public Header getHeader();
	
	@JsonIgnoreProperties({Context.PARENT_PROPERTY, Context.CHILDREN_PROPERTY})
	@JsonGetter(value = SOURCE_PROPERTY)
	public Out getSource();
	
	@JsonIgnore
	public void setSource(Out source);
	
	@JsonIgnoreProperties({Context.PARENT_PROPERTY, Context.CHILDREN_PROPERTY})
	@JsonGetter(value = TARGET_PROPERTY)
	public In getTarget();
	
	@JsonIgnore
	public void setTarget(In target);
	
}
