package org.gcube.informationsystem.base.reference.relations;

import org.gcube.informationsystem.base.reference.ER;
import org.gcube.informationsystem.base.reference.entities.BaseEntity;
import org.gcube.informationsystem.base.reference.properties.Header;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.annotations.ISProperty;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;

@Abstract
//@JsonDeserialize(as=BaseRelationImpl.class) Do not uncomment to manage subclasses
public interface BaseRelation<Out extends BaseEntity, In extends BaseEntity> extends ER {
	
	public static final String NAME = "BaseRelation"; // BaseRelation.class.getSimpleName();
	
	public static final String SOURCE_PROPERTY = "source";
	public static final String TARGET_PROPERTY = "target";
	
	/* Overriding getHeader method to create Header property in type */
	@ISProperty(name = HEADER_PROPERTY, mandatory = true, nullable = false)
	@Override
	public Header getHeader();
	
	@JsonGetter(value=SOURCE_PROPERTY)
	public Out getSource();
	
	@JsonIgnore
	public void setSource(Out source);
	
	@JsonGetter(value=TARGET_PROPERTY)
	public In getTarget();
	
	@JsonIgnore
	public void setTarget(In target);
	
}