package org.gcube.informationsystem.base.reference.properties;

import org.gcube.informationsystem.base.reference.ISManageable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * @author Luca Frosini (ISTI - CNR)
 * Root Class for Property types. It creates a base common type, which is useful
 * for management purpose.
 */
// @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = ISManageable.CLASS_PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public interface BaseProperty extends ISManageable {
	
	public static final String NAME = "BaseProperty"; //BaseProperty.class.getSimpleName();
	public static final String DESCRIPTION = "This is the very base class for Property";
	public static final String VERSION = "1.0.0";
	
}
