/**
 * 
 */
package org.gcube.informationsystem.base.reference;

import java.util.Arrays;

import org.gcube.informationsystem.context.impl.entities.ContextImpl;
import org.gcube.informationsystem.context.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.context.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.impl.entities.DummyFacet;
import org.gcube.informationsystem.model.impl.entities.DummyResource;
import org.gcube.informationsystem.model.impl.entities.EntityImpl;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.informationsystem.model.impl.entities.ResourceImpl;
import org.gcube.informationsystem.model.impl.properties.PropertyImpl;
import org.gcube.informationsystem.model.impl.relations.ConsistsOfImpl;
import org.gcube.informationsystem.model.impl.relations.DummyIsRelatedTo;
import org.gcube.informationsystem.model.impl.relations.IsRelatedToImpl;
import org.gcube.informationsystem.model.impl.relations.RelationImpl;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.types.impl.entities.EntityTypeDefinitionImpl;
import org.gcube.informationsystem.types.impl.properties.PropertyDefinitionImpl;
import org.gcube.informationsystem.types.impl.properties.PropertyTypeDefinitionImpl;
import org.gcube.informationsystem.types.impl.relations.RelationTypeDefinitionImpl;
import org.gcube.informationsystem.types.reference.entities.EntityTypeDefinition;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.types.reference.properties.PropertyTypeDefiniton;
import org.gcube.informationsystem.types.reference.relations.RelationTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 * 
 * Enumerates the basic type names.
 */
public enum AccessType {

	PROPERTY(Property.class, Property.NAME, PropertyImpl.class, null),
	PROPERTY_DEFINITION(PropertyDefinition.class, PropertyDefinition.NAME, PropertyDefinitionImpl.class, null),
	PROPERTY_TYPE_DEFINITION(PropertyTypeDefiniton.class, PropertyTypeDefiniton.NAME, PropertyTypeDefinitionImpl.class, null),
	
	CONTEXT(Context.class, Context.NAME, ContextImpl.class, null),
	IS_PARENT_OF(IsParentOf.class, IsParentOf.NAME, IsParentOfImpl.class, null),
	
	ENTITY_TYPE_DEFINITION(EntityTypeDefinition.class, EntityTypeDefinition.NAME, EntityTypeDefinitionImpl.class, null),
	RELATION_TYPE_DEFINITION(RelationTypeDefinition.class, RelationTypeDefinition.NAME, RelationTypeDefinitionImpl.class, null),
		
	ENTITY(Entity.class, Entity.NAME, EntityImpl.class, null),
	RESOURCE(Resource.class, Resource.NAME, ResourceImpl.class, DummyResource.class),
	FACET(Facet.class, Facet.NAME, FacetImpl.class, DummyFacet.class),
		
	RELATION(Relation.class, Relation.NAME, RelationImpl.class, null),
	IS_RELATED_TO(IsRelatedTo.class, IsRelatedTo.NAME, IsRelatedToImpl.class, DummyIsRelatedTo.class),
	CONSISTS_OF(ConsistsOf.class, ConsistsOf.NAME, ConsistsOfImpl.class, null);
	
	private static Logger logger = LoggerFactory.getLogger(AccessType.class);
	
	private final Class<? extends ISManageable> clz;
	private final Class<? extends ISManageable> implementationClass;
	private final Class<? extends ISManageable> dummyImplementationClass;
	
	private final String name;
	private final String lowerCaseFirstCharacter;
	
	<ISM extends ISManageable, ISMC extends ISM, ISMD extends ISMC>
	AccessType(Class<ISM> clz, String name, Class<ISMC> implementationClass, Class<ISMD> dummyImplementationClass){
		this.clz = clz;
		this.implementationClass = implementationClass;
		this.dummyImplementationClass = dummyImplementationClass;
		this.name = name;
		this.lowerCaseFirstCharacter = name.substring(0, 1).toLowerCase() + name.substring(1);
	}
	
	@SuppressWarnings("unchecked")
	public <ISM extends ISManageable> Class<ISM> getTypeClass(){
		return (Class<ISM>) clz;
	}
	
	@SuppressWarnings("unchecked")
	public <ISM extends ISManageable, ISMC extends ISM> Class<ISMC> getImplementationClass() {
		return (Class<ISMC>) implementationClass;
	}
	
	@SuppressWarnings("unchecked")
	public <ISM extends ISManageable, ISMC extends ISM, ISMD extends ISMC> Class<ISMD> getDummyImplementationClass() {
		return (Class<ISMD>) dummyImplementationClass;
	}
	
	public String getName(){
		return name;
	}
	
	public String lowerCaseFirstCharacter() {
		return lowerCaseFirstCharacter;
	}
	
	@Override
	public String toString(){
		return name;
	}
	
	public static AccessType getAccessType(Class<?> clz) {
		AccessType ret  =null;
		
		AccessType[] accessTypes = AccessType.values();
		for (AccessType accessType : accessTypes) {
			Class<? extends ISManageable> typeClass = accessType.getTypeClass();
			if (typeClass.isAssignableFrom(clz)) {
				if(ret==null || ret.getTypeClass().isAssignableFrom(typeClass)){
					ret = accessType;
				}
			}
		}
		
		if(ret !=null){
			return ret;
		}else{
			String error = String
					.format("The provided class %s does not belong to any of defined AccessTypes %s",
							clz.getSimpleName(), Arrays.toString(accessTypes));
			logger.trace(error);
			throw new RuntimeException(error);
		}
	}
}
