package org.gcube.informationsystem.base.impl.relations;

import org.gcube.informationsystem.base.impl.ERImpl;
import org.gcube.informationsystem.base.reference.entities.BaseEntity;
import org.gcube.informationsystem.base.reference.relations.BaseRelation;

public abstract class BaseRelationImpl<Out extends BaseEntity, In extends BaseEntity> extends ERImpl implements BaseRelation<Out, In> {
	
	/**
	 * Generated Serial Version UID 
	 */
	private static final long serialVersionUID = 28704968813390512L;
	
	protected Out source;
	protected In target;

	protected BaseRelationImpl() {
		super();		
	}

	protected BaseRelationImpl(Out source, In target) {
		this();
		this.source = source;
		this.target = target;
	}

	@Override
	public Out getSource() {
		return source;
	}
	
	@Override
	public void setSource(Out source) {
		this.source = source;
	}

	@Override
	public In getTarget() {
		return target;
	}

	@Override
	public void setTarget(In target) {
		this.target = target;
	}

}