/**
 * 
 */
package org.gcube.informationsystem.base.impl;

import java.io.StringWriter;

import org.gcube.informationsystem.base.reference.ER;
import org.gcube.informationsystem.base.reference.properties.Header;
import org.gcube.informationsystem.utils.ISMapper;

import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=ER.NAME)
public abstract class ERImpl extends ISManageableImpl implements ER {
	
	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -494123926950181618L;
	
	protected Header header;
	
	public ERImpl(){
		super();
	}
	
	@Override
	public Header getHeader() {
		return header;
	}
	
	@Override
	public void setHeader(Header header){
		this.header = header;
	}
	
	@Override
	public String toString(){
		StringWriter stringWriter = new StringWriter();
		try {
			ISMapper.marshal(this, stringWriter);
			return stringWriter.toString();
		}catch(Exception e){
			try {
				ISMapper.marshal(this.header, stringWriter);
				return stringWriter.toString();
			} catch(Exception e1){
				return super.toString();
			}
		}
	}
}
