/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.model.reference.ISManageable;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.types.Type;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeBinder {
    private static Logger logger = LoggerFactory.getLogger(TypeBinder.class);
    private static final String EDGE_CLASS_NAME = "E";
    private static final String VERTEX_CLASS_NAME = "V";
    private static final String NAME = "NAME";
    private static final String DESCRIPTION = "DESCRIPTION";
    public static final String UUID_PATTERN = "^([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}){1}$";
    public static final String URI_PATTERN = null;
    public static final String URL_PATTERN = null;

    public static String getType(Class<? extends ISManageable> clz) {
        return TypeBinder.getStaticStringFieldByName(clz, NAME, clz.getSimpleName());
    }

    private static String getStaticStringFieldByName(Class<? extends ISManageable> type, String fieldName, String defaultValue) {
        try {
            Field field = type.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (String)field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return defaultValue;
        }
    }

    public static String serializeTypeDefinition(TypeDefinition typeDefinition) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)typeDefinition);
        return json;
    }

    public static String serializeType(Class<? extends ISManageable> type) throws Exception {
        TypeDefinition typeDefinition = TypeBinder.createTypeDefinition(type);
        return TypeBinder.serializeTypeDefinition(typeDefinition);
    }

    public static TypeDefinition deserializeTypeDefinition(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (TypeDefinition)mapper.readValue(json, TypeDefinition.class);
    }

    public static String serializeTypeDefinitions(List<TypeDefinition> typeDefinitions) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(typeDefinitions);
        return json;
    }

    public static List<TypeDefinition> deserializeTypeDefinitions(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, TypeDefinition.class);
        return (List)mapper.readValue(json, (JavaType)type);
    }

    private static Class<?> getGenericClass(java.lang.reflect.Type type) {
        TypeVariable typeVariable = (TypeVariable)type;
        java.lang.reflect.Type[] bounds = typeVariable.getBounds();
        java.lang.reflect.Type t = bounds[0];
        return (Class)t;
    }

    public static TypeDefinition createTypeDefinition(Class<? extends ISManageable> clz) {
        TypeDefinition typeDefinition = new TypeDefinition();
        typeDefinition.name = TypeBinder.getType(clz);
        typeDefinition.description = TypeBinder.getStaticStringFieldByName(clz, DESCRIPTION, "");
        typeDefinition.abstractType = false;
        if (clz.isAnnotationPresent(Abstract.class)) {
            typeDefinition.abstractType = true;
        }
        if (Entity.class.isAssignableFrom(clz)) {
            typeDefinition.superClasses = Resource.class.isAssignableFrom(clz) ? TypeBinder.retrieveSuperClasses(clz, Resource.class, "Entity") : (Facet.class.isAssignableFrom(clz) ? TypeBinder.retrieveSuperClasses(clz, Facet.class, "Entity") : TypeBinder.retrieveSuperClasses(clz, Entity.class, VERTEX_CLASS_NAME));
        } else if (Relation.class.isAssignableFrom(clz)) {
            typeDefinition.superClasses = IsRelatedTo.class.isAssignableFrom(clz) ? TypeBinder.retrieveSuperClasses(clz, IsRelatedTo.class, "Relation") : (ConsistsOf.class.isAssignableFrom(clz) ? TypeBinder.retrieveSuperClasses(clz, ConsistsOf.class, "Relation") : TypeBinder.retrieveSuperClasses(clz, Relation.class, EDGE_CLASS_NAME));
            TypeVariable<Class<? extends ISManageable>>[] typeParameters = clz.getTypeParameters();
            Class<?> sourceClass = TypeBinder.getGenericClass(typeParameters[0]);
            Class<?> targetClass = TypeBinder.getGenericClass(typeParameters[1]);
            typeDefinition.sourceType = TypeBinder.getType(sourceClass);
            typeDefinition.targetType = TypeBinder.getType(targetClass);
        } else if (Property.class.isAssignableFrom(clz)) {
            typeDefinition.superClasses = TypeBinder.retrieveSuperClasses(clz, Property.class, clz == Property.class ? null : "Property");
        } else {
            throw new RuntimeException("Serialization required");
        }
        if (!Resource.class.isAssignableFrom(clz)) {
            typeDefinition.properties = TypeBinder.retrieveListOfProperties(clz);
        }
        logger.trace("{} : {} ", clz, (Object)typeDefinition);
        return typeDefinition;
    }

    private static Set<PropertyDefinition> retrieveListOfProperties(Class<?> type) {
        HashSet<PropertyDefinition> properties = new HashSet<PropertyDefinition>();
        for (Method m : type.getDeclaredMethods()) {
            m.setAccessible(true);
            if (!m.isAnnotationPresent(ISProperty.class) || m.isBridge()) continue;
            ISProperty propAnnotation = m.getAnnotation(ISProperty.class);
            PropertyDefinition prop = TypeBinder.getProperty(propAnnotation, m);
            properties.add(prop);
            logger.trace("Property {} retrieved in type {} ", (Object)prop, (Object)type.getSimpleName());
        }
        return properties;
    }

    private static String getPropertyNameFromMethodName(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.replace("get", "");
        }
        if (name.startsWith("is")) {
            name = name.replace("is", "");
        }
        if (name.length() > 0) {
            name = Character.toLowerCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        }
        return name;
    }

    private static PropertyDefinition getProperty(ISProperty propertyAnnotation, Method method) {
        String name = propertyAnnotation.name().isEmpty() ? TypeBinder.getPropertyNameFromMethodName(method) : propertyAnnotation.name();
        PropertyDefinition propertyDefinition = new PropertyDefinition();
        propertyDefinition.name = name;
        propertyDefinition.description = propertyAnnotation.description();
        propertyDefinition.mandatory = propertyAnnotation.mandatory();
        propertyDefinition.notnull = !propertyAnnotation.nullable();
        propertyDefinition.readonly = propertyAnnotation.readonly();
        if (propertyAnnotation.max() > 0) {
            propertyDefinition.max = propertyAnnotation.max();
        }
        if (propertyAnnotation.max() >= propertyAnnotation.min() && propertyAnnotation.min() > 0) {
            propertyDefinition.min = propertyAnnotation.min();
        }
        if (!propertyAnnotation.regexpr().isEmpty()) {
            propertyDefinition.regexp = propertyAnnotation.regexpr();
        }
        logger.trace("Looking for property type {}", method.getReturnType());
        Class<?> type = method.getReturnType();
        propertyDefinition.type = Type.OType.PROPERTY.getIntValue();
        if (Property.class.isAssignableFrom(type)) {
            if (type != Property.class) {
                propertyDefinition.linkedClass = TypeBinder.getType(type);
            }
        } else if (Type.getTypeByClass(type) != null) {
            propertyDefinition.type = Type.getTypeByClass(type).getIntValue();
            if (propertyDefinition.type > 9 && propertyDefinition.type <= 12) {
                java.lang.reflect.Type genericReturnType = method.getGenericReturnType();
                logger.trace("Generic Return Type {} for method {}", (Object)genericReturnType, (Object)method);
                java.lang.reflect.Type[] actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments();
                java.lang.reflect.Type genericType = null;
                for (java.lang.reflect.Type t : actualTypeArguments) {
                    logger.trace("Generic Return Type {} for method {} - Actual Type Argument : {}", new Object[]{genericReturnType, method, t});
                    genericType = t;
                }
                Class genericClass = (Class)genericType;
                Type.OType linkedOType = Type.getTypeByClass(genericClass);
                if (linkedOType != null) {
                    propertyDefinition.linkedType = linkedOType.getIntValue();
                } else {
                    propertyDefinition.linkedClass = TypeBinder.getType(genericClass);
                }
            }
            if ((propertyDefinition.regexp == null || propertyDefinition.regexp.compareTo("") == 0) && propertyDefinition.type.intValue() == Type.OType.STRING.getIntValue()) {
                if (Enum.class.isAssignableFrom(type)) {
                    ?[] constants = type.getEnumConstants();
                    StringBuilder stringBuilder = new StringBuilder("^(");
                    for (int i = 0; i < constants.length; ++i) {
                        stringBuilder.append(constants[i].toString());
                        if (i >= constants.length - 1) continue;
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(")$");
                    propertyDefinition.regexp = stringBuilder.toString();
                }
                if (UUID.class.isAssignableFrom(type)) {
                    propertyDefinition.regexp = UUID_PATTERN;
                }
                if (URI.class.isAssignableFrom(type)) {
                    propertyDefinition.regexp = TypeBinder.URI_PATTERN;
                }
                if (URL.class.isAssignableFrom(type)) {
                    propertyDefinition.regexp = TypeBinder.URL_PATTERN;
                }
            }
            if (propertyDefinition.regexp != null && propertyDefinition.regexp.compareTo("") == 0) {
                propertyDefinition.regexp = null;
            }
        } else {
            throw new RuntimeException("Type " + type.getSimpleName() + " not reconized");
        }
        return propertyDefinition;
    }

    private static Set<String> retrieveSuperClasses(Class<? extends ISManageable> type, Class<? extends ISManageable> baseClass, String topSuperClass) {
        Class<?>[] interfaces;
        HashSet<String> interfaceList = new HashSet<String>();
        if (type == baseClass) {
            interfaceList.add(topSuperClass);
            return interfaceList;
        }
        for (Class<?> interfaceClass : interfaces = type.getInterfaces()) {
            if (!baseClass.isAssignableFrom(interfaceClass)) continue;
            Class<?> clz = interfaceClass;
            interfaceList.add(TypeBinder.getType(clz));
        }
        return interfaceList;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PropertyDefinition {
        private String name = "";
        private String description = "";
        private boolean mandatory = false;
        private boolean readonly = false;
        private boolean notnull = false;
        private Integer max = null;
        private Integer min = null;
        private String regexp = null;
        private Integer linkedType = null;
        private String linkedClass = null;
        private Integer type = null;

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public boolean isNotnull() {
            return this.notnull;
        }

        public Integer getMax() {
            return this.max;
        }

        public Integer getMin() {
            return this.min;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public Integer getLinkedType() {
            return this.linkedType;
        }

        public String getLinkedClass() {
            return this.linkedClass;
        }

        public Integer getType() {
            return this.type;
        }

        @JsonIgnore
        public String getTypeStringValue() {
            if (this.type == null) {
                return null;
            }
            return Type.OType.values()[this.type].getStringValue();
        }

        public String toString() {
            return "Property [name=" + this.name + ", description=" + this.description + ", mandatory=" + this.mandatory + ", readonly=" + this.readonly + ", notnull=" + this.notnull + ", max=" + this.max + ", min=" + this.min + ", regexpr=" + this.regexp + ", type = " + this.type + " (" + this.getTypeStringValue() + "), linkedType = " + this.linkedType + ", linkedClass = " + this.linkedClass + "]";
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TypeDefinition {
        protected String name;
        protected String description;
        @JsonProperty(value="abstract")
        protected boolean abstractType;
        protected Set<String> superClasses;
        protected Set<PropertyDefinition> properties;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected String sourceType;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected String targetType;

        public String toString() {
            return "TypeDefinition [name=" + this.name + (this.sourceType == null ? "" : "(" + this.sourceType + "->" + this.targetType + ")") + ", description=" + this.description + ", abstract=" + this.abstractType + ", superClasses=" + this.superClasses + ", properties=" + this.properties + "]";
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isAbstract() {
            return this.abstractType;
        }

        public Set<String> getSuperClasses() {
            return this.superClasses;
        }

        public Set<PropertyDefinition> getProperties() {
            return this.properties;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getTargetType() {
            return this.targetType;
        }
    }
}

