/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.model.reference;

import java.util.Arrays;
import org.gcube.informationsystem.model.impl.entities.ContextImpl;
import org.gcube.informationsystem.model.impl.entities.DummyFacet;
import org.gcube.informationsystem.model.impl.entities.DummyResource;
import org.gcube.informationsystem.model.impl.entities.EntityImpl;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.informationsystem.model.impl.entities.ResourceImpl;
import org.gcube.informationsystem.model.impl.properties.DummyProperty;
import org.gcube.informationsystem.model.impl.properties.PropertyImpl;
import org.gcube.informationsystem.model.impl.relations.ConsistsOfImpl;
import org.gcube.informationsystem.model.impl.relations.DummyConsistsOf;
import org.gcube.informationsystem.model.impl.relations.DummyIsRelatedTo;
import org.gcube.informationsystem.model.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.model.impl.relations.IsRelatedToImpl;
import org.gcube.informationsystem.model.impl.relations.RelationImpl;
import org.gcube.informationsystem.model.reference.ISManageable;
import org.gcube.informationsystem.model.reference.entities.Context;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AccessType {
    PROPERTY(Property.class, "Property", PropertyImpl.class, DummyProperty.class),
    CONTEXT(Context.class, "Context", ContextImpl.class, null),
    IS_PARENT_OF(IsParentOf.class, "IsParentOf", IsParentOfImpl.class, null),
    ENTITY(Entity.class, "Entity", EntityImpl.class, null),
    RESOURCE(Resource.class, "Resource", ResourceImpl.class, DummyResource.class),
    FACET(Facet.class, "Facet", FacetImpl.class, DummyFacet.class),
    RELATION(Relation.class, "Relation", RelationImpl.class, null),
    IS_RELATED_TO(IsRelatedTo.class, "IsRelatedTo", IsRelatedToImpl.class, DummyIsRelatedTo.class),
    CONSISTS_OF(ConsistsOf.class, "ConsistsOf", ConsistsOfImpl.class, DummyConsistsOf.class);

    private static Logger logger;
    private final Class<? extends ISManageable> clz;
    private final Class<? extends ISManageable> implementationClass;
    private final Class<? extends ISManageable> dummyImplementationClass;
    private final String name;
    private final String lowerCaseFirstCharacter;

    private <ISM extends ISManageable, ISMC extends ISM, ISMD extends ISMC> AccessType(Class<ISM> clz, String name, Class<ISMC> implementationClass, Class<ISMD> dummyImplementationClass) {
        this.clz = clz;
        this.implementationClass = implementationClass;
        this.dummyImplementationClass = dummyImplementationClass;
        this.name = name;
        this.lowerCaseFirstCharacter = name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public <ISM extends ISManageable> Class<ISM> getTypeClass() {
        return this.clz;
    }

    public <ISM extends ISManageable, ISMC extends ISM> Class<ISMC> getImplementationClass() {
        return this.implementationClass;
    }

    public <ISM extends ISManageable, ISMC extends ISM, ISMD extends ISMC> Class<ISMD> getDummyImplementationClass() {
        return this.dummyImplementationClass;
    }

    public String getName() {
        return this.name;
    }

    public String lowerCaseFirstCharacter() {
        return this.lowerCaseFirstCharacter;
    }

    public String toString() {
        return this.name;
    }

    public static AccessType getAccessType(Class<?> clz) {
        AccessType[] accessTypes;
        AccessType ret = null;
        for (AccessType accessType : accessTypes = AccessType.values()) {
            Class typeClass = accessType.getTypeClass();
            if (!typeClass.isAssignableFrom(clz) || ret != null && !ret.getTypeClass().isAssignableFrom(typeClass)) continue;
            ret = accessType;
        }
        if (ret != null) {
            return ret;
        }
        String error = String.format("The provided class %s does not belong to any of defined AccessTypes %s", clz.getSimpleName(), Arrays.toString((Object[])accessTypes));
        logger.trace(error);
        throw new RuntimeException(error);
    }

    static {
        logger = LoggerFactory.getLogger(AccessType.class);
    }
}

