/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.model.impl.utils;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.gcube.informationsystem.model.impl.utils.ERDeserializer;
import org.gcube.informationsystem.model.impl.utils.ObjectMappingERAction;
import org.gcube.informationsystem.model.impl.utils.discovery.ISMDiscovery;
import org.gcube.informationsystem.model.impl.utils.discovery.RegistrationProvider;
import org.gcube.informationsystem.model.impl.utils.discovery.SchemaAction;
import org.gcube.informationsystem.model.reference.AccessType;
import org.gcube.informationsystem.model.reference.ISManageable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ISMapper {
    private static Logger logger;
    protected static final ObjectMapper mapper;

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static void registerPackages(List<Package> packages) {
        ObjectMappingERAction schemaAction = new ObjectMappingERAction(mapper);
        try {
            ISMDiscovery.manageISM((SchemaAction)schemaAction, packages);
        }
        catch (Exception e) {
            logger.error("Error registering types", (Throwable)e);
        }
    }

    public static void registerPackages(Package ... packages) {
        ObjectMappingERAction schemaAction = new ObjectMappingERAction(mapper);
        try {
            ISMDiscovery.manageISM((SchemaAction)schemaAction, packages);
        }
        catch (Exception e) {
            logger.error("Error registering types", (Throwable)e);
        }
    }

    public static <ISM extends ISManageable> void registerSubtypes(Class<ISM> ... classes) {
        mapper.registerSubtypes((Class[])classes);
    }

    public static <T extends OutputStream, ISM extends ISManageable> T marshal(ISM object, T stream) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(stream, object);
        return stream;
    }

    public static <T extends Writer, ISM extends ISManageable> T marshal(ISM object, T writer) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(writer, object);
        return writer;
    }

    public static <ISM extends ISManageable> String marshal(ISM object) throws JsonProcessingException {
        return mapper.writeValueAsString(object);
    }

    public static <ISM extends ISManageable> String marshal(List<ISM> list) throws JsonProcessingException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, ISManageable.class);
        return mapper.writerFor((JavaType)type).writeValueAsString(list);
    }

    public static <ISM extends ISManageable> String marshal(ISM[] array) throws JsonProcessingException {
        return mapper.writeValueAsString(array);
    }

    public static <ISM extends ISManageable> ISM unmarshal(Class<ISM> clz, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        return (ISM)((ISManageable)mapper.readValue(reader, clz));
    }

    public static <ISM extends ISManageable> ISM unmarshal(Class<ISM> clz, InputStream stream) throws JsonParseException, JsonMappingException, IOException {
        return (ISM)((ISManageable)mapper.readValue(stream, clz));
    }

    public static <ISM extends ISManageable> ISM unmarshal(Class<ISM> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        return (ISM)((ISManageable)mapper.readValue(string, clz));
    }

    public static <ISM extends ISManageable> ISM unmarshalWithReader(Class<ISM> reader, String string) throws JsonParseException, JsonMappingException, IOException {
        return (ISM)((ISManageable)mapper.readerFor(reader).readValue(string));
    }

    public static <ISM extends ISManageable> List<ISM> unmarshalList(Class<ISM> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, clz);
        return (List)mapper.readValue(string, (JavaType)type);
    }

    public static <ISM extends ISManageable> List<ISM> unmarshalList(String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, ISManageable.class);
        return (List)mapper.readValue(string, (JavaType)type);
    }

    static {
        AccessType[] accessTypes;
        logger = LoggerFactory.getLogger(ISMapper.class);
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (AccessType accessType : accessTypes = AccessType.values()) {
            Class clz = accessType.getTypeClass();
            Class dummyClz = accessType.getDummyImplementationClass();
            if (dummyClz == null) continue;
            SimpleModule isModule = new SimpleModule(accessType.getName());
            isModule.addDeserializer(clz, new ERDeserializer(clz, mapper));
            mapper.registerModule((Module)isModule);
            mapper.registerSubtypes(new Class[]{dummyClz});
        }
        ObjectMappingERAction schemaAction = new ObjectMappingERAction(mapper);
        try {
            ISMDiscovery.manageISM((SchemaAction)schemaAction, new Package[0]);
        }
        catch (Exception e) {
            logger.error("Error registering types", (Throwable)e);
        }
        ServiceLoader<RegistrationProvider> regsitrationProviders = ServiceLoader.load(RegistrationProvider.class);
        for (RegistrationProvider registrationProvider : regsitrationProviders) {
            ISMapper.registerPackages(registrationProvider.getPackagesToRegister());
        }
    }
}

