/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.model.impl.entity;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.informationsystem.model.impl.entity.DummyFacet;
import org.gcube.informationsystem.model.impl.entity.DummyResource;
import org.gcube.informationsystem.model.impl.entity.EntityImpl;
import org.gcube.informationsystem.model.impl.relation.ConsistsOfImpl;
import org.gcube.informationsystem.model.impl.relation.IsRelatedToImpl;
import org.gcube.informationsystem.model.reference.entity.Facet;
import org.gcube.informationsystem.model.reference.entity.Resource;
import org.gcube.informationsystem.model.reference.relation.ConsistsOf;
import org.gcube.informationsystem.model.reference.relation.IsIdentifiedBy;
import org.gcube.informationsystem.model.reference.relation.IsRelatedTo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="Resource")
public abstract class ResourceImpl
extends EntityImpl
implements Resource {
    private static final long serialVersionUID = -3117918737458706846L;
    private static Logger logger = LoggerFactory.getLogger(ResourceImpl.class);
    protected List<ConsistsOf<? extends Resource, ? extends Facet>> consistsOfList = new ArrayList<ConsistsOf<? extends Resource, ? extends Facet>>();
    protected List<IsRelatedTo<? extends Resource, ? extends Resource>> isRelatedToList = new ArrayList<IsRelatedTo<? extends Resource, ? extends Resource>>();

    protected ResourceImpl() {
    }

    @Override
    public void addFacet(UUID uuid) {
        DummyFacet facet = new DummyFacet(uuid);
        this.addFacet((ConsistsOf)((Object)facet));
    }

    @Override
    public <F extends Facet> void addFacet(F facet) {
        ConsistsOfImpl<ResourceImpl, F> consistsOf = new ConsistsOfImpl<ResourceImpl, F>(this, facet, null);
        this.addFacet(consistsOf);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> void addFacet(C relation) {
        if (relation.getSource() != this) {
            String message = String.format("%s Source %s is not this. %s != %s", "ConsistsOf", "Resource", ((Resource)relation.getSource()).toString(), this.toString());
            logger.error(message);
            throw new RuntimeException(message);
        }
        this.consistsOfList.add(relation);
    }

    @Override
    public void attachResource(UUID uuid) {
        DummyResource resource = new DummyResource(uuid);
        this.attachResource(resource);
    }

    @Override
    public <R extends Resource> void attachResource(R resource) {
        IsRelatedToImpl<ResourceImpl, R> isRelatedTo = new IsRelatedToImpl<ResourceImpl, R>(this, resource, null);
        this.attachResource(isRelatedTo);
    }

    public void attachResource(IsRelatedTo relation) {
        String message = String.format("%s Source %s is not this. %s != %s", "IsRelatedTo", "Resource", relation.getSource(), this.toString());
        if (relation.getSource() == null) {
            throw new RuntimeException(message);
        }
        if (relation.getSource().getHeader() != null && relation.getSource().getHeader().getUUID() != null && this.header != null && this.header.getUUID() != null && relation.getSource().getHeader().getUUID().compareTo(this.header.getUUID()) != 0) {
            throw new RuntimeException(message);
        }
        if (relation.getSource() != this) {
            relation.setSource(this);
        }
        this.isRelatedToList.add(relation);
    }

    @Override
    public List<? extends Facet> getIdentificationFacets() {
        ArrayList identificationFacets = new ArrayList();
        for (ConsistsOf<? extends Resource, ? extends Facet> consistsOfInstance : this.consistsOfList) {
            if (!IsIdentifiedBy.class.isAssignableFrom(consistsOfInstance.getClass())) continue;
            identificationFacets.add(consistsOfInstance.getTarget());
        }
        return identificationFacets;
    }

    @Override
    public List<ConsistsOf<? extends Resource, ? extends Facet>> getConsistsOf() {
        return this.consistsOfList;
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> List<C> getConsistsOf(Class<C> clz) {
        ArrayList<ConsistsOf<? extends Resource, ? extends Facet>> list = new ArrayList<ConsistsOf<? extends Resource, ? extends Facet>>();
        for (ConsistsOf<? extends Resource, ? extends Facet> consistsOf : this.consistsOfList) {
            if (!clz.isInstance(consistsOf)) continue;
            ConsistsOf<? extends Resource, ? extends Facet> c = consistsOf;
            list.add(c);
        }
        return list;
    }

    @Override
    public List<IsRelatedTo<? extends Resource, ? extends Resource>> getIsRelatedTo() {
        return this.isRelatedToList;
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> List<I> getIsRelatedTo(Class<I> clz) {
        ArrayList<IsRelatedTo<? extends Resource, ? extends Resource>> list = new ArrayList<IsRelatedTo<? extends Resource, ? extends Resource>>();
        for (IsRelatedTo<? extends Resource, ? extends Resource> isRelatedTo : this.isRelatedToList) {
            if (!clz.isInstance(isRelatedTo)) continue;
            IsRelatedTo<? extends Resource, ? extends Resource> i = isRelatedTo;
            list.add(i);
        }
        return list;
    }

    @Override
    public List<? extends Facet> getFacets() {
        ArrayList list = new ArrayList();
        for (ConsistsOf<? extends Resource, ? extends Facet> consistsOf : this.consistsOfList) {
            list.add(consistsOf.getTarget());
        }
        return list;
    }

    @Override
    public <F extends Facet> List<F> getFacets(Class<F> clz) {
        ArrayList<Facet> list = new ArrayList<Facet>();
        for (ConsistsOf<? extends Resource, ? extends Facet> consistsOf : this.consistsOfList) {
            if (!clz.isInstance(consistsOf.getTarget())) continue;
            Facet f = (Facet)consistsOf.getTarget();
            list.add(f);
        }
        return list;
    }

    @Override
    public <F extends Facet, C extends ConsistsOf<? extends Resource, F>> List<C> getConsistsOf(Class<C> clz, Class<F> facetClz) {
        ArrayList<ConsistsOf<? extends Resource, ? extends Facet>> list = new ArrayList<ConsistsOf<? extends Resource, ? extends Facet>>();
        for (ConsistsOf<? extends Resource, ? extends Facet> consistsOf : this.consistsOfList) {
            if (!clz.isInstance(consistsOf) || !facetClz.isInstance(consistsOf.getTarget())) continue;
            ConsistsOf<? extends Resource, ? extends Facet> c = consistsOf;
            list.add(c);
        }
        return list;
    }

    @Override
    public <F extends Facet, C extends ConsistsOf<? extends Resource, F>> List<F> getFacets(Class<C> clz, Class<F> facetClz) {
        ArrayList<Facet> list = new ArrayList<Facet>();
        for (ConsistsOf<? extends Resource, ? extends Facet> consistsOf : this.consistsOfList) {
            if (!clz.isInstance(consistsOf) || !facetClz.isInstance(consistsOf.getTarget())) continue;
            Facet f = (Facet)consistsOf.getTarget();
            list.add(f);
        }
        return list;
    }
}

