/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.model.impl.utils.discovery;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.gcube.informationsystem.model.impl.utils.discovery.ReflectionUtility;
import org.gcube.informationsystem.model.impl.utils.discovery.SchemaAction;
import org.gcube.informationsystem.model.reference.ISManageable;
import org.gcube.informationsystem.model.reference.annotations.ISProperty;
import org.gcube.informationsystem.model.reference.embedded.Embedded;
import org.gcube.informationsystem.model.reference.entity.Entity;
import org.gcube.informationsystem.model.reference.relation.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISMDiscovery<ISM extends ISManageable> {
    private static Logger logger = LoggerFactory.getLogger(ISMDiscovery.class);
    protected final Class<ISM> root;
    protected final List<Package> packages;
    protected final List<Class<ISM>> discovered;

    public List<Class<ISM>> getDiscovered() {
        return this.discovered;
    }

    public ISMDiscovery(Class<ISM> root) {
        this.root = root;
        this.packages = new ArrayList<Package>();
        this.addPackage(root.getPackage());
        this.discovered = new ArrayList<Class<ISM>>();
        this.add(root);
    }

    public void addPackage(Package p) {
        this.packages.add(p);
    }

    protected void add(Class<ISM> clz) {
        this.discovered.add(clz);
        logger.debug("+ Added {}.", clz);
    }

    protected void analizeISM(Class<ISM> clz) {
        logger.trace("Analizyng {}", clz);
        if (!clz.isInterface()) {
            logger.trace("- Discarding {} that is not an interface", clz);
            return;
        }
        if (!this.root.isAssignableFrom(clz)) {
            logger.trace("- Discarding {} because is not a {}", clz, (Object)this.root.getClass().getSimpleName());
            return;
        }
        if (this.discovered.contains(clz)) {
            logger.trace("- Discarding {} because was already managed", clz);
            return;
        }
        Class<?>[] interfaces = clz.getInterfaces();
        GenericDeclaration[] genericDeclarationArray = interfaces;
        int n = genericDeclarationArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz;
            Class<?> parent = clazz = genericDeclarationArray[i];
            this.analizeISM(parent);
        }
        if (this.root == Embedded.class) {
            for (GenericDeclaration genericDeclaration : clz.getDeclaredMethods()) {
                ((Method)genericDeclaration).setAccessible(true);
                if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(ISProperty.class) || !this.root.isAssignableFrom(((Method)genericDeclaration).getReturnType())) continue;
                Class<?> type = ((Method)genericDeclaration).getReturnType();
                this.analizeISM(type);
            }
        }
        this.add(clz);
    }

    public void discover() throws Exception {
        for (Package p : this.packages) {
            List<Class<?>> classes = ReflectionUtility.getClassesForPackage(p);
            Iterator<Class<?>> iterator = classes.iterator();
            while (iterator.hasNext()) {
                Class<?> clz;
                Class<?> ism = clz = iterator.next();
                this.analizeISM(ism);
            }
        }
    }

    public static void manageISM(SchemaAction schemaAction, List<Package> packages) throws Exception {
        if (Objects.nonNull(packages) && packages.size() > 0) {
            ISMDiscovery.manageISM(schemaAction, (Package[])packages.stream().toArray(Package[]::new));
        } else {
            ISMDiscovery.manageISM(schemaAction, new Package[0]);
        }
    }

    public static void manageISM(SchemaAction schemaAction, Package ... packages) throws Exception {
        ISMDiscovery<Embedded> embeddedDiscovery = new ISMDiscovery<Embedded>(Embedded.class);
        if (Objects.nonNull(packages)) {
            Arrays.stream(packages).forEach(p -> embeddedDiscovery.addPackage((Package)p));
        }
        embeddedDiscovery.discover();
        for (Class<Embedded> clazz : embeddedDiscovery.getDiscovered()) {
            logger.info("Going to create : {}", clazz);
            schemaAction.manageEmbeddedClass(clazz);
        }
        ISMDiscovery<Entity> entityDiscovery = new ISMDiscovery<Entity>(Entity.class);
        if (Objects.nonNull(packages)) {
            Arrays.stream(packages).forEach(p -> entityDiscovery.addPackage((Package)p));
        }
        entityDiscovery.discover();
        for (Class<Entity> clazz : entityDiscovery.getDiscovered()) {
            logger.info("Going to create : {}", clazz);
            schemaAction.manageEntityClass(clazz);
        }
        ISMDiscovery<Relation> iSMDiscovery = new ISMDiscovery<Relation>(Relation.class);
        if (Objects.nonNull(packages)) {
            Arrays.stream(packages).forEach(p -> relationDiscovery.addPackage((Package)p));
        }
        iSMDiscovery.discover();
        for (Class<Relation> relation : iSMDiscovery.getDiscovered()) {
            logger.info("Going to create : {}", relation);
            schemaAction.manageRelationClass(relation);
        }
    }
}

