/**
 * 
 */
package org.gcube.informationsystem.model.impl.embedded;

import java.net.URI;

import org.gcube.informationsystem.model.reference.embedded.ValueSchema;

import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=ValueSchema.NAME)
public class ValueSchemaImpl extends EmbeddedImpl implements ValueSchema {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -7510493487587070094L;

	protected String value;

	protected URI schema;
	
	public ValueSchemaImpl(){
		super();
	}
	
	@Override
	public String getValue() {
		return this.value;
	}

	@Override
	public void setValue(String value) {
		this.value = value;
	}

	/* (non-Javadoc)
	 * @see org.gcube.informationsystem.model.reference.embedded.TypedProperty#getType()
	 */
	@Override
	public URI getType() {
		return this.schema;
	}

	/* (non-Javadoc)
	 * @see org.gcube.informationsystem.model.reference.embedded.TypedProperty#setType(java.lang.Object)
	 */
	@Override
	public void setType(URI type) {
		this.schema = type;
	}

}
