/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.impl.entity;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.informationsystem.impl.embedded.HeaderImpl;
import org.gcube.informationsystem.impl.entity.EntityImpl;
import org.gcube.informationsystem.impl.relation.IsParentOfImpl;
import org.gcube.informationsystem.model.entity.Context;
import org.gcube.informationsystem.model.exceptions.InvalidEntity;
import org.gcube.informationsystem.model.relation.IsParentOf;

@JsonTypeName(value="Context")
public class ContextImpl
extends EntityImpl
implements Context {
    private static final long serialVersionUID = -5070590328223454087L;
    protected String name;
    protected IsParentOf<Context, Context> parent = null;
    protected List<IsParentOf<Context, Context>> children = new ArrayList<IsParentOf<Context, Context>>();

    protected ContextImpl() {
    }

    public ContextImpl(String name) {
        this(name, null);
    }

    public ContextImpl(String name, UUID uuid) {
        this();
        this.name = name;
        if (uuid == null) {
            uuid = UUID.randomUUID();
        }
        this.header = new HeaderImpl(uuid);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IsParentOf<Context, Context> getParent() {
        return this.parent;
    }

    @Override
    public void setParent(UUID uuid) {
        ContextImpl parent = null;
        if (uuid != null) {
            parent = new ContextImpl();
            parent.setHeader(new HeaderImpl(uuid));
        }
        this.setParent(parent);
    }

    @Override
    public void setParent(Context context) {
        IsParentOfImpl<Context, ContextImpl> isParentOf = null;
        if (context != null) {
            isParentOf = new IsParentOfImpl<Context, ContextImpl>(context, this, null);
        }
        this.setParent(isParentOf);
    }

    @JsonSetter(value="parent")
    protected void setParentFromJson(IsParentOf<Context, Context> isParentOf) throws JsonProcessingException, InvalidEntity {
        if (isParentOf != null) {
            Context parent = (Context)isParentOf.getSource();
            isParentOf.setTarget(this);
            ((ContextImpl)parent).addChild(isParentOf);
        }
        this.setParent(isParentOf);
    }

    @Override
    public void setParent(IsParentOf<Context, Context> isParentOf) {
        this.parent = isParentOf;
    }

    @Override
    public List<IsParentOf<Context, Context>> getChildren() {
        return this.children;
    }

    @JsonSetter(value="children")
    protected void setChildrenFromJson(List<IsParentOf<Context, Context>> children) throws InvalidEntity, JsonProcessingException {
        for (IsParentOf<Context, Context> isParentOf : children) {
            this.addChildFromJson(isParentOf);
        }
    }

    protected void addChildFromJson(IsParentOf<Context, Context> isParentOf) throws InvalidEntity, JsonProcessingException {
        isParentOf.setSource(this);
        this.addChild(isParentOf);
    }

    @Override
    public void addChild(UUID uuid) {
        ContextImpl child = new ContextImpl();
        child.setHeader(new HeaderImpl(uuid));
        this.addChild(child);
    }

    @Override
    public void addChild(Context child) {
        IsParentOfImpl<Context, Context> isParentOf = new IsParentOfImpl<Context, Context>(this, child, null);
        this.addChild(isParentOf);
    }

    @Override
    public void addChild(IsParentOf<Context, Context> isParentOf) {
        ((ContextImpl)isParentOf.getTarget()).setParent(this);
        this.children.add(isParentOf);
    }
}

