/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.model.annotations.Abstract;
import org.gcube.informationsystem.model.annotations.ISProperty;
import org.gcube.informationsystem.model.embedded.Embedded;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeBinder {
    private static Logger logger = LoggerFactory.getLogger(TypeBinder.class);
    private static final String EDGE_CLASS_NAME = "E";
    private static final String VERTEX_CLASS_NAME = "V";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String UUID_PATTERN = "^([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}){1}$";
    public static final String URI_PATTERN = null;
    public static final String URL_PATTERN = null;

    private static String getStaticStringFieldByName(Class<?> type, String fieldName, String defaultValue) {
        try {
            Field field = type.getDeclaredField(fieldName);
            return (String)field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return defaultValue;
        }
    }

    public static String serializeTypeDefinition(TypeDefinition typeDefinition) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)typeDefinition);
        return json;
    }

    public static String serializeType(Class<?> type) throws Exception {
        TypeDefinition typeDefinition = TypeBinder.createTypeDefinition(type);
        return TypeBinder.serializeTypeDefinition(typeDefinition);
    }

    public static TypeDefinition deserializeTypeDefinition(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (TypeDefinition)mapper.readValue(json, TypeDefinition.class);
    }

    public static String serializeTypeDefinitions(List<TypeDefinition> typeDefinitions) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(typeDefinitions);
        return json;
    }

    public static List<TypeDefinition> deserializeTypeDefinitions(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, TypeDefinition.class);
        return (List)mapper.readValue(json, (JavaType)type);
    }

    public static TypeDefinition createTypeDefinition(Class<?> type) {
        TypeDefinition typeDefinition = new TypeDefinition();
        typeDefinition.name = TypeBinder.getStaticStringFieldByName(type, NAME, type.getSimpleName());
        typeDefinition.description = TypeBinder.getStaticStringFieldByName(type, DESCRIPTION, "");
        typeDefinition.abstractType = false;
        if (type.isAnnotationPresent(Abstract.class)) {
            typeDefinition.abstractType = true;
        }
        if (Entity.class.isAssignableFrom(type)) {
            typeDefinition.superClasses = Resource.class.isAssignableFrom(type) ? TypeBinder.retrieveSuperClasses(type, Resource.class, "Entity") : (Facet.class.isAssignableFrom(type) ? TypeBinder.retrieveSuperClasses(type, Facet.class, "Entity") : TypeBinder.retrieveSuperClasses(type, Entity.class, VERTEX_CLASS_NAME));
        } else if (Relation.class.isAssignableFrom(type)) {
            typeDefinition.superClasses = IsRelatedTo.class.isAssignableFrom(type) ? TypeBinder.retrieveSuperClasses(type, IsRelatedTo.class, "Relation") : (ConsistsOf.class.isAssignableFrom(type) ? TypeBinder.retrieveSuperClasses(type, ConsistsOf.class, "Relation") : TypeBinder.retrieveSuperClasses(type, Relation.class, EDGE_CLASS_NAME));
        } else if (Embedded.class.isAssignableFrom(type)) {
            typeDefinition.superClasses = TypeBinder.retrieveSuperClasses(type, Embedded.class, type == Embedded.class ? null : "Embedded");
        } else {
            throw new RuntimeException("Serialization required");
        }
        if (!Resource.class.isAssignableFrom(type)) {
            typeDefinition.properties = TypeBinder.retrieveListOfProperties(type);
        }
        logger.trace("{} TypeDefinition {} ", type, (Object)typeDefinition);
        return typeDefinition;
    }

    protected static Set<Property> retrieveListOfProperties(Class<?> type) {
        HashSet<Property> properties = new HashSet<Property>();
        for (Method m : type.getDeclaredMethods()) {
            m.setAccessible(true);
            if (!m.isAnnotationPresent(ISProperty.class)) continue;
            ISProperty propAnnotation = m.getAnnotation(ISProperty.class);
            Property prop = TypeBinder.getProperty(propAnnotation, m);
            properties.add(prop);
            logger.trace("Property {} retrieved in type {} ", (Object)prop, (Object)type.getSimpleName());
        }
        return properties;
    }

    protected static String getPropertyNameFromMethodName(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.replace("get", "");
        }
        if (name.startsWith("is")) {
            name = name.replace("is", "");
        }
        if (name.length() > 0) {
            name = Character.toLowerCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        }
        return name;
    }

    protected static Property getProperty(ISProperty propertyAnnotation, Method method) {
        String name = propertyAnnotation.name().isEmpty() ? TypeBinder.getPropertyNameFromMethodName(method) : propertyAnnotation.name();
        Property property = new Property();
        property.name = name;
        property.description = propertyAnnotation.description();
        property.mandatory = propertyAnnotation.mandatory();
        property.notnull = !propertyAnnotation.nullable();
        property.readonly = propertyAnnotation.readonly();
        if (propertyAnnotation.max() > 0) {
            property.max = propertyAnnotation.max();
        }
        if (propertyAnnotation.max() >= propertyAnnotation.min() && propertyAnnotation.min() > 0) {
            property.min = propertyAnnotation.min();
        }
        if (!propertyAnnotation.regexpr().isEmpty()) {
            property.regexp = propertyAnnotation.regexpr();
        }
        logger.trace("Looking for property type {}", method.getReturnType());
        Class<?> type = method.getReturnType();
        property.type = Type.OType.EMBEDDED.getIntValue();
        if (Embedded.class.isAssignableFrom(type)) {
            if (type != Embedded.class) {
                property.linkedClass = TypeBinder.getStaticStringFieldByName(type, NAME, type.getSimpleName());
            }
        } else if (Type.getTypeByClass(type) != null) {
            property.type = Type.getTypeByClass(type).getIntValue();
            if (property.type > 9 && property.type <= 12) {
                java.lang.reflect.Type genericReturnType = method.getGenericReturnType();
                logger.trace("Generic Return Type {} for method {}", (Object)genericReturnType, (Object)method);
                java.lang.reflect.Type[] actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments();
                java.lang.reflect.Type genericType = null;
                for (java.lang.reflect.Type t : actualTypeArguments) {
                    logger.trace("Generic Return Type {} for method {} - Actual Type Argument : {}", new Object[]{genericReturnType, method, t});
                    genericType = t;
                }
                Class genericClass = (Class)genericType;
                Type.OType linkedOType = Type.getTypeByClass(genericClass);
                if (linkedOType != null) {
                    property.linkedType = linkedOType.getIntValue();
                } else {
                    property.linkedClass = TypeBinder.getStaticStringFieldByName(genericClass, NAME, genericClass.getSimpleName());
                }
            }
            if ((property.regexp == null || property.regexp.compareTo("") == 0) && property.type.intValue() == Type.OType.STRING.getIntValue()) {
                if (Enum.class.isAssignableFrom(type)) {
                    ?[] constants = type.getEnumConstants();
                    StringBuilder stringBuilder = new StringBuilder("^(");
                    for (int i = 0; i < constants.length; ++i) {
                        stringBuilder.append(constants[i].toString());
                        if (i >= constants.length - 1) continue;
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(")$");
                    property.regexp = stringBuilder.toString();
                }
                if (UUID.class.isAssignableFrom(type)) {
                    property.regexp = UUID_PATTERN;
                }
                if (URI.class.isAssignableFrom(type)) {
                    property.regexp = TypeBinder.URI_PATTERN;
                }
                if (URL.class.isAssignableFrom(type)) {
                    property.regexp = TypeBinder.URL_PATTERN;
                }
            }
            if (property.regexp != null && property.regexp.compareTo("") == 0) {
                property.regexp = null;
            }
        } else {
            throw new RuntimeException("Type " + type.getSimpleName() + " not reconized");
        }
        return property;
    }

    private static Set<String> retrieveSuperClasses(Class<?> type, Class<?> baseClass, String topSuperClass) {
        Class<?>[] interfaces;
        HashSet<String> interfaceList = new HashSet<String>();
        if (type == baseClass) {
            interfaceList.add(topSuperClass);
            return interfaceList;
        }
        for (Class<?> interfaceClass : interfaces = type.getInterfaces()) {
            if (!baseClass.isAssignableFrom(interfaceClass)) continue;
            interfaceList.add(TypeBinder.getStaticStringFieldByName(interfaceClass, NAME, interfaceClass.getSimpleName()));
        }
        return interfaceList;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Property {
        private String name = "";
        private String description = "";
        private boolean mandatory = false;
        private boolean readonly = false;
        private boolean notnull = false;
        private Integer max = null;
        private Integer min = null;
        private String regexp = null;
        private Integer linkedType = null;
        private String linkedClass = null;
        private Integer type = null;

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public boolean isNotnull() {
            return this.notnull;
        }

        public Integer getMax() {
            return this.max;
        }

        public Integer getMin() {
            return this.min;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public Integer getLinkedType() {
            return this.linkedType;
        }

        public String getLinkedClass() {
            return this.linkedClass;
        }

        public Integer getType() {
            return this.type;
        }

        @JsonIgnore
        public String getTypeStringValue() {
            if (this.type == null) {
                return null;
            }
            return Type.OType.values()[this.type].getStringValue();
        }

        public String toString() {
            return "Property [name=" + this.name + ", description=" + this.description + ", mandatory=" + this.mandatory + ", readonly=" + this.readonly + ", notnull=" + this.notnull + ", max=" + this.max + ", min=" + this.min + ", regexpr=" + this.regexp + ", type = " + this.type + " (" + this.getTypeStringValue() + "), linkedType = " + this.linkedType + ", linkedClass = " + this.linkedClass + "]";
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TypeDefinition {
        protected String name;
        protected String description;
        @JsonProperty(value="abstract")
        protected boolean abstractType;
        protected Set<String> superClasses;
        protected Set<Property> properties;

        public String toString() {
            return "TypeDefinition [name=" + this.name + ", description=" + this.description + ", abstract=" + this.abstractType + ", superClasses=" + this.superClasses + ", properties=" + this.properties + "]";
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isAbstract() {
            return this.abstractType;
        }

        public Set<String> getSuperClasses() {
            return this.superClasses;
        }

        public Set<Property> getProperties() {
            return this.properties;
        }
    }
}

