/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.impl.entity;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.informationsystem.impl.entity.DummyFacet;
import org.gcube.informationsystem.impl.entity.DummyResource;
import org.gcube.informationsystem.impl.entity.EntityImpl;
import org.gcube.informationsystem.impl.relation.ConsistsOfImpl;
import org.gcube.informationsystem.impl.relation.IsRelatedToImpl;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsIdentifiedBy;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="Resource")
public abstract class ResourceImpl
extends EntityImpl
implements Resource {
    private static final long serialVersionUID = -3117918737458706846L;
    private static Logger logger = LoggerFactory.getLogger(ResourceImpl.class);
    protected List<ConsistsOf<? extends Resource, ? extends Facet>> consistsOf = new ArrayList<ConsistsOf<? extends Resource, ? extends Facet>>();
    protected List<IsRelatedTo<? extends Resource, ? extends Resource>> isRelatedTo = new ArrayList<IsRelatedTo<? extends Resource, ? extends Resource>>();

    protected ResourceImpl() {
    }

    @Override
    public <F extends Facet> void addFacet(F facet) {
        this.consistsOf.add(new ConsistsOfImpl<ResourceImpl, F>(this, facet, null));
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> void addFacet(C relation) {
        if (relation.getSource() != this) {
            String message = String.format("%s Source %s is not this. %s != %s", "ConsistsOf", "Resource", ((Resource)relation.getSource()).toString(), this.toString());
            logger.error(message);
            throw new RuntimeException(message);
        }
        this.consistsOf.add(relation);
    }

    @Override
    public void attachFacet(UUID uuid) {
        DummyFacet facet = new DummyFacet(uuid);
        this.consistsOf.add(new ConsistsOfImpl<ResourceImpl, DummyFacet>(this, facet, null));
    }

    @Override
    public void attachFacet(ConsistsOf<? extends Resource, ? extends Facet> relation) {
        this.consistsOf.add(relation);
    }

    @Override
    public void detachFacet(UUID uuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attachResource(UUID uuid) {
        DummyResource resource = new DummyResource(uuid);
        this.isRelatedTo.add(new IsRelatedToImpl<ResourceImpl, DummyResource>(this, resource, null));
    }

    public void attachResource(IsRelatedTo relation) {
        String message = String.format("%s Source %s is not this. %s != %s", "ConsistsOf", "Resource", relation.getSource(), this.toString());
        if (relation.getSource() == null) {
            throw new RuntimeException(message);
        }
        if (relation.getSource().getHeader() != null && relation.getSource().getHeader().getUUID() != null && this.header != null && this.header.getUUID() != null && relation.getSource().getHeader().getUUID().compareTo(this.header.getUUID()) != 0) {
            throw new RuntimeException(message);
        }
        this.isRelatedTo.add(relation);
    }

    @Override
    public List<? extends Facet> getIdentificationFacets() {
        ArrayList identificationFacets = new ArrayList();
        for (ConsistsOf<? extends Resource, ? extends Facet> consistsOfInstance : this.consistsOf) {
            if (!IsIdentifiedBy.class.isAssignableFrom(consistsOfInstance.getClass())) continue;
            identificationFacets.add(consistsOfInstance.getTarget());
        }
        return identificationFacets;
    }

    @Override
    public List<ConsistsOf<? extends Resource, ? extends Facet>> getConsistsOf() {
        return this.consistsOf;
    }

    @Override
    public List<IsRelatedTo<? extends Resource, ? extends Resource>> getIsRelatedTo() {
        return this.isRelatedTo;
    }
}

