/**
 * 
 */
package org.gcube.informationsystem.impl.relation;

import java.util.UUID;

import org.gcube.informationsystem.model.embedded.RelationProperty;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.IsRelatedTo;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class IsRelatedToImpl<Out extends Resource, In extends Resource> extends
		RelationImpl<Out, In> implements IsRelatedTo<Out, In> {

	/**
	 * @param source
	 * @param target
	 * @param relationProperty
	 */
	public IsRelatedToImpl(Out source, In target,
			RelationProperty relationProperty) {
		super(source, target, relationProperty);
	}
	
	@SuppressWarnings("unchecked")
	public IsRelatedToImpl(Out source, UUID targetUUID,
			RelationProperty relationProperty) {
		super(source, relationProperty);
		this.target = (In) new DummyResource(targetUUID);
	}

}
