/**
 * 
 */
package org.gcube.informationsystem.impl.relation;

import java.util.UUID;

import org.gcube.informationsystem.model.embedded.RelationProperty;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 * 
 */
public class ConsistsOfImpl<Out extends Resource, In extends Facet> extends
		RelationImpl<Out, In> implements ConsistsOf<Out, In> {

	/**
	 * @param source
	 * @param target
	 * @param relationProperty
	 */
	public ConsistsOfImpl(Out source, In target,
			RelationProperty relationProperty) {
		super(source, target, relationProperty);
	}
	
	@SuppressWarnings("unchecked")
	public ConsistsOfImpl(Out source, UUID targetUUID,
			RelationProperty relationProperty) {
		super(source, relationProperty);
		this.target = (In) new DummyFacet(targetUUID);
	}
}
